% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_Imputation.R
\name{CombineMIs}
\alias{CombineMIs}
\title{Combine Multiple Imputations}
\usage{
CombineMIs(points, covs)
}
\arguments{
\item{points}{List of point estimates, potentially vector valued.}

\item{covs}{List of sampling covariances, potentially matrix valued.}
}
\value{
List containing the final point estimate (`point`) and 
  sampling covariance (`cov`).
}
\description{
Combines point estimates and standard errors across multiple imputations.
}
\examples{
set.seed(100)

# Generate data and introduce missingness.
data <- rGMM(n = 25, d = 2, k = 1)
data[1, 1] <- NA
data[2, 2] <- NA
data[3, ] <- NA 

# Fit GMM.
fit <- FitGMM(data)

# Lists to store summary statistics.
points <- list()
covs <- list()

# Perform 50 multiple imputations.
# For each, calculate the marginal mean and its sampling variance.
for (i in seq_len(50)) {
  imputed <- GenImputation(fit)
  points[[i]] <- apply(imputed, 2, mean)
  covs[[i]] <- cov(imputed) / nrow(imputed)
}

# Combine summary statistics across imputations.
results <- CombineMIs(points, covs)
}
