% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DMD.DM.R, R/DMD.GDM.R, R/DMD.NegMN.R,
%   R/MGLMfit.R
\name{DMD.DM.fit}
\alias{DMD.DM.fit}
\alias{DMD.GDM.fit}
\alias{DMD.NegMN.fit}
\alias{MGLMfit}
\title{Fit multivariate discrete distributions}
\usage{
DMD.DM.fit(
  data,
  init,
  weight,
  epsilon = 1e-08,
  maxiters = 150,
  display = FALSE
)

DMD.GDM.fit(
  data,
  init,
  weight,
  epsilon = 1e-08,
  maxiters = 150,
  display = FALSE
)

DMD.NegMN.fit(
  data,
  init,
  weight,
  epsilon = 1e-08,
  maxiters = 150,
  display = FALSE
)

MGLMfit(
  data,
  dist,
  init,
  weight,
  epsilon = 1e-08,
  maxiters = 150,
  display = FALSE
)
}
\arguments{
\item{data}{a data frame or matrix containing the count data. 
Rows of the matrix represent observations and columns are the categories. 
Rows and columns of all zeros are automatically removed.}

\item{init}{an optional vector of initial value of the parameter estimates. Should have the same dimension as the estimated parameters. See \code{\link{dist}} for details.}

\item{weight}{an optional vector of weights assigned to each row of the data. Should be Null or a numeric vector with the length equal to the number of rows of \code{data}. 
If \code{weight=NULL}, equal weights of all ones will be assigned.}

\item{epsilon}{an optional numeric controlling the stopping criterion. The algorithm terminates when the relative change in the log-likelihoods of two successive iterates is less than \code{epsilon}. The default value is \code{epsilon=1e-8}.}

\item{maxiters}{an optional number controlling the maximum number of iterations. The default value is \code{maxiters=150}.}

\item{display}{an optional logical variable controlling the display of iterations. The default value is FALSE.}

\item{dist}{a description of the distribution to fit. Choose from \code{"MN"}, \code{"DM"}, \code{"GDM"}, \code{"NegMN"}. See \code{\link{dist}} for details.}
}
\value{
Returns an object of S4 class \code{"MGLMfit"}. An object of class \code{"MGLMfit"} is a list containing at least the following components: \itemize{
\item{\code{estimate}}{ the vector of the distribution prameter estimates.}
\item{\code{SE}}{ the vector of standard errors of the estimates.}
\item{\code{vcov}}{ the variance-covariance matrix of the estimates.}
\item{\code{logL}}{ the loglikelihood value.}
\item{\code{iter}}{ the number of iterations used.}
\item{\code{BIC}}{ Bayesian information criterion.}
\item{\code{AIC}}{ Akaike information criterion.}
\item{\code{distribution}}{ the distribution fitted.}
\item{\code{LRT}}{ when \code{dist="DM"} or \code{"GDM"}, it is the likelihood ratio test statistic for comparing the current model to the multinomial model. No LRT provided when \code{dist="NegMN"}.} 
\item{\code{LRTpvalue}}{ the likelihood ratio test P value.}
\item{\code{gradient}}{ the gradient at the estimated parameter values.}
\item{\code{DoF}}{ the degrees of freedom of the model.}
}
}
\description{
Fit the specified multivariate discrete distribution.
}
\details{
See \code{\link{dist}} for details about model parameterization.
}
\examples{
data(rnaseq)
Y <- as.matrix(rnaseq[, 1:6])
fit <- MGLMfit(data=Y, dist="GDM") 


}
\author{
Yiwen Zhang and Hua Zhou
}
\keyword{Distribution}
\keyword{Models}
\keyword{fitting}
