% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MEM_X_hat.R
\name{MEM_X_hat}
\alias{MEM_X_hat}
\title{Get MEM substitution for
(generalized) linear regression with one functional covariate with measurement error.}
\usage{
MEM_X_hat(
  data.W,
  method = c("UP_MEM", "MP_MEM", "average"),
  d = 3,
  family.W = c("gaussian", "poisson"),
  smooth = FALSE
)
}
\arguments{
\item{data.W}{A 3-dimensional array, represents \eqn{W}, the measurement of \eqn{X}.
Each row represents a subject.
Each column represent a measurement (time) point.
Each layer represents an observation.}

\item{method}{The method to construct the substitution \eqn{X}.
Available options: \code{'UP_MEM'}, \code{'MP_MEM'}, 'average'.}

\item{d}{The number of time points involved for MP_MEM (default and miniumn is 3).}

\item{family.W}{Distribution of \eqn{W} given \eqn{X},  Available options: \code{"gaussian"}, \code{"poisson"}.}

\item{smooth}{Whether to smooth the substitution of \eqn{X}. Default is \code{FALSE}.}
}
\value{
A numeric value matrix of \eqn{\hat X_i(t)}.
}
\description{
The function to get the data of \eqn{\hat X_i(t)} using the mixed model based
measurement error bias correction method
proposed by Luan et al.
See \code{\link{ME.fcRegression_MEM}}
}
\examples{
data(MECfda.data.sim.0.1)
X_hat = MEM_X_hat(data.W = MECfda.data.sim.0.1$W,
                  method = 'UP_MEM',
                  family.W = "gaussian")

}
\references{
Luan, Yuanyuan, et al. "Scalable regression calibration approaches to
correcting measurement error in multi-level generalized functional linear regression models
with heteroscedastic measurement errors." arXiv preprint arXiv:2305.12624 (2023).
}
