% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FourierSeries2fun.R
\name{FourierSeries2fun}
\alias{FourierSeries2fun}
\alias{FourierSeries2fun,Fourier_series,numeric-method}
\title{Compute the value of the Fourier summation series}
\usage{
FourierSeries2fun(object, x)

\S4method{FourierSeries2fun}{Fourier_series,numeric}(object, x)
}
\arguments{
\item{object}{an object of \code{\link{Fourier_series}} class.}

\item{x}{Value of \eqn{x}.}
}
\value{
A numeric atomic vector
}
\description{
Compute the value of the Fourier summation series
\deqn{f(x) = \frac{a_0}{2} +
\sum_{k=1}^{p_a} a_k \cos{(\frac{2\pi}{T}k(x-t_0))} +
\sum_{k=1}^{p_b} b_k \sin{(\frac{2\pi}{T}k(x-t_0))},
\qquad x\in[t_0,t_0+T]}
at some certain point(s).
}
\examples{
fsc = Fourier_series(
           double_constant = 0.5,
           cos = c(0,0.3),
           sin = c(1,0.7),
           k_cos = 1:2,
           )
          FourierSeries2fun(fsc,1:5)

}
\author{
Heyang Ji
}
