% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_info.R
\name{topic_info}
\alias{topic_info}
\title{Obtain information from guest edited topics}
\usage{
topic_info(journal_urls, sample_size, sleep = 2, show_progress = TRUE)
}
\arguments{
\item{journal_urls}{A list of MDPI topics URLs}

\item{sample_size}{A number. How many topics do you want to explore from the main vector. Leave blank for all}

\item{sleep}{Number of seconds between scraping iterations. 2 sec. by default}

\item{show_progress}{Logical. If \code{TRUE}, a progress bar is displayed during the function execution. Defaults to \code{TRUE}.}
}
\value{
A data frame (class: \code{data.frame}) with the following columns:
\describe{
\item{topic}{The URL of the topics contained in the topic, not considering editorial type articles}
\item{flags}{Number of articles in the topic with guest editorial pressence}
\item{prop_flag}{Proportion of articles in the topic in which a guest editor is present}
\item{deadline}{Time at which the topic was or will be closed}
\item{latest_sub}{Time at which last article present in the topic was submitted}
\item{rt_sum_vector2}{Numeric vector showing number of articles in which each individual guest editor is present}
\item{aca_flag}{Number of articles in the topic where the academic editor is a guest editor too}
\item{d_over_deadline}{Day differential between topic closure and latest article submission}
\item{journals}{List of journals participating in the topic}
}
}
\description{
#'
Extracts data from topics, including guest editors' paper counts excluding editorials, time between last submission and issue closure, and whether guest editors served as academic editors for any published papers. Includes names of journals participating in topic
}
\examples{
\dontrun{
ge_issue<-"https://www.mdpi.com/topics/mechanisms_resistance_plant_diseases_volume"
ge_info<-topic_info(ge_issue)
}
}
