% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R2.vglm.R
\name{R2.vglm}
\alias{R2.vglm}
\title{Calculate (pseudo) \eqn{R^2} for \code{vglm} objects}
\usage{
R2.vglm(
  model,
  method = c("mcfadden", "nagelkerke", "efron", "coxsnell", "tjur")
)
}
\arguments{
\item{model}{a \code{vglm} object.}

\item{method}{method for calculation of \eqn{R^2}.}
}
\value{
\code{R2.vglm} returns \eqn{R^2}.
}
\description{
Calculate (pseudo) \eqn{R^2} for \code{vglm} objects
}
\examples{
if(require("VGAM")){
  fit <- vglm(Species ~ Sepal.Length,
              family = multinomial(),
              data = iris)
  R2.vglm(fit)
}
}
\author{
Mathijs Deen
}
