% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdc_test.R
\name{mdc_test}
\alias{mdc_test}
\title{MDC-Based Dependence Tests Between Multivariate Data and a Covariate}
\usage{
mdc_test(x, y, method, permutations = 999, parallel = TRUE, ncores = -1)
}
\arguments{
\item{x}{Vector or matrix  where rows represent samples, and columns represent variables.}

\item{y}{Covariate vector.}

\item{method}{Character string indicating the test to perform. One of:
\itemize{
\item \code{"MDCU"}: U-centering permutation test.
\item \code{"MDCV"}: Double-centering permutation test.
\item \code{"FMDCU"}: Fast asymptotic test with U-centering.
\item \code{"All"}: All of the above.
}}

\item{permutations}{Number of permutations. Defaults to 999.}

\item{parallel}{Logical. Whether to use parallel computing. Defaults to \code{TRUE}.}

\item{ncores}{Number of threads for parallel computing (used only if \code{parallel = TRUE}).}
}
\value{
A list containing the test results and p-values.
}
\description{
Computes dependence between a multivariate dataset \code{x} and a univariate covariate \code{y}
using different variants of the MDC (martingale difference correlation) test.
}
\examples{
set.seed(123)
x <- matrix(rnorm(50 * 5), nrow = 50)
y <- rbinom(50, 1, 0.5)
mdc_test(x, y, method = "FMDCU")

}
\references{
Shao, X., and Zhang, J. (2014). Martingale difference correlation...
}
