% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Phixy.R
\name{Phixy}
\alias{Phixy}
\title{Scaled Bivariate Normal Approximation}
\usage{
Phixy(x, y, rho, korder = 3, app = TRUE)
}
\arguments{
\item{x, y}{P(X<=x,Y<=y).}

\item{rho}{correlation coefficient.}

\item{korder}{order of Legendre approximation.}

\item{app}{bool value TRUE for approximation, FALSE for integral.}
}
\value{
P(X<=x,Y<=y).
}
\description{
Standard bivariate normal distribution approximated with Legendre polynomials.
}
\examples{
library(mvtnorm)
pmvnorm(upper = c(1,-1),sigma = matrix(c(1,0.5,0.5,1),2,2))
Phixy(1,-1,0.5,2,app=TRUE)
Phixy(1,-1,0.5,app=TRUE)
}
