% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/M.R
\name{M}
\alias{M}
\title{Computes an inconsistency index for a collection of means.}
\usage{
M(mu_S, patterns)
}
\arguments{
\item{mu_S}{A list of means \eqn{\mu_\mathbb{S}}.}

\item{patterns}{A list of missingness patterns.}
}
\value{
The value of \eqn{M()}.
}
\description{
A function that computes the inconsistency index \eqn{M(\mu_\mathbb{S})} for a collection of
means, as defined in Algorithm 2 in Section 6 of \insertCite{BB2024;textual}{MCARtest}.
}
\examples{
library(MASS)

d = 3
n = 200
SigmaS=list() #Random 2x2 correlation matrices (necessarily consistent)
for(j in 1:d){
x=runif(2,min=-1,max=1); y=runif(2,min=-1,max=1); SigmaS[[j]]=cov2cor(x\%*\%t(x) + y\%*\%t(y))
}

X = data.frame(matrix(nrow = 3*n, ncol = 3))
X[1:n, c(1,2)] = mvrnorm(n, c(0,0), SigmaS[[1]])
X[(n+1):(2*n), c(2, 3)] = mvrnorm(n, c(0,0), SigmaS[[2]])
X[(2*n+1):(3*n), c(1, 3)] = mvrnorm(n, c(0,0), SigmaS[[3]])
X = as.matrix(X)

tmp = get_SigmaS(X)
M(tmp$mu_S, tmp$patterns)
}
\references{
\insertRef{BB2024}{MCARtest}
}
