% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMRM.R
\name{rMRM}
\alias{rMRM}
\title{Simulate Data from a Mixed Regression Model with GLG Random Effects}
\usage{
rMRM(n, m, theta, X)
}
\arguments{
\item{n}{Integer. Number of clusters or subjects.}

\item{m}{Integer vector of length \code{n}. Each element indicates the number of observations per cluster.}

\item{theta}{Numeric vector. The first element is the scale or dispersion parameter for the random effects,
and the remaining values are the fixed effects coefficients, including the intercept.}

\item{X}{A data frame or matrix of covariates with \code{n} rows (one per cluster). Should not include the intercept.}
}
\value{
A \code{tibble} containing the simulated dataset with the following columns:
\describe{
  \item{Ind}{Cluster or subject ID (integer from 1 to \code{n}).}
  \item{y}{Binary response variable (0 or 1).}
  \item{x1, x2, ...}{Covariates as defined in \code{X}, repeated according to cluster size.}
}
The output also has an attribute \code{"proportions"} indicating the proportions of 0's and 1's in \code{y}.
}
\description{
This function simulates clustered binary response data from a mixed regression model with random effects.
The model allows for different link functions and random effect distributions.
}
\examples{
set.seed(123)
n <- 500
m <- rep(3,n)
theta <- c(0.5,1,-2,1)
set.seed(123)
x1 <- runif(sum(m))
x2 <- rnorm(sum(m))
X <- cbind(x1,x2)
set.seed(456)
data1 <- rMRM(n,m,theta,X)
head(data1)

}
