% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAVE_DATA.R
\name{mave.data}
\alias{mave.data}
\title{The reduced data matrix}
\usage{
mave.data(dr, x, dim = NULL)
}
\arguments{
\item{dr}{the object returned by \code{\link[MAVE]{mave}} or \code{\link[MAVE]{mave.dim}}}

\item{x}{the original data matrix of p dimensions}

\item{dim}{the dimension of the reduced data matrix.}
}
\description{
The function returns the reduced data matrix of the original data. The reduced data matrix
is obtained by the original data multiplied by the dimension reduction directions of given
dimension.
}
\examples{

x <- matrix(rnorm(400),100,4)
y <- x[,1]+x[,2]+as.matrix(rnorm(100))
dr <- mave(y~x)
x.reduced <- mave.data(dr,x,3)
}
\seealso{
\code{\link[MAVE]{coef.mave}} for obtaining the dimension reduction directions
}
