% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-ModelEstimation.R
\name{generate_apc_lincombs}
\alias{generate_apc_lincombs}
\title{Generate Age-Period-Cohort Linear Combinations for INLA}
\usage{
generate_apc_lincombs(
  apc_format,
  data,
  strata,
  reference_strata,
  age = "age",
  period = "period",
  cohort = "cohort"
)
}
\arguments{
\item{apc_format}{Character string containing any combination of \code{"a"}, \code{"p"}, \code{"c"}:
\describe{
\item{\code{"a"}}{include age contrasts}
\item{\code{"p"}}{include period contrasts}
\item{\code{"c"}}{include cohort contrasts}
}
e.g. \code{"ap"} to generate age and period contrasts only.}

\item{data}{A \code{data.frame} containing the variables specified by \code{age}, \code{period}, \code{cohort}, and \code{strata}.
The age, period, and cohort variables must be integer-valued (or coercible to integer).}

\item{strata}{String giving the name of the factor column in \code{data} that defines strata.}

\item{reference_strata}{String indicating which level of \code{strata} should be used as the reference.}

\item{age}{String name of the column in \code{data} containing age indices (default \code{"age"}).}

\item{period}{String name of the column in \code{data} containing period indices (default \code{"period"}).}

\item{cohort}{String name of the column in \code{data} containing cohort indices (default \code{"cohort"}).}
}
\value{
A named \code{list} of linear combination objects as returned by
\code{inla.make.lincomb()} (\code{INLA} function). Each element corresponds to one contrast,
with names of the form \dQuote{Age = x, Strata = y vs ref}, \dQuote{Period = x, Strata = y vs ref},
or \dQuote{Cohort = x, Strata = y vs ref}, depending on \code{apc_format}.
}
\description{
Constructs a set of linear combinations (contrasts) for age, period, and/or cohort effects
across different strata, relative to a specified reference strata, suitable for use with
\code{inla.make.lincomb} from the \code{INLA} package.
}
\details{
For each specified dimension (\code{a}, \code{p}, \code{c}), the function loops over all
unique values of age, period, or cohort in the data, and over all strata levels except
the reference.  It then constructs a contrast that subtracts the effect in the reference
stratum from the effect in the other strata at each index.
}
