% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-DataPreprocessing.R
\name{aggregate_df}
\alias{aggregate_df}
\title{Aggregate data across an entire data frame using sufficient statistics}
\usage{
aggregate_df(
  data,
  gaussian = NULL,
  gaussian.precision.scales = NULL,
  binomial = NULL
)
}
\arguments{
\item{data}{A data frame.}

\item{gaussian}{Gaussian columns in \code{data} to be aggregated. The Gaussian observations are collapsed into an \code{inla.mdata} object compatible with the \code{agaussian} family, see the documentation for the \code{agaussian} family in \code{INLA} for details.
\strong{Defaults to \code{NULL} (optional).}}

\item{gaussian.precision.scales}{Scales for the precision of Gaussian observations. \cr
Must be one of: \cr
\itemize{
\item \code{NULL}: Use default scales of 1 for all observations in all \code{gaussian} columns.
\item A single numeric vector: Applied only if \emph{exactly one} column is specified in \code{gaussian}. Length must match \code{nrow(data)}.
\item A \emph{named list}: Where \code{names(gaussian.precision.scales)} are the names of the Gaussian columns (must match columns specified in \code{gaussian}). Each list element must be a numeric vector of scales for that column, with length matching \code{nrow(data)}. \cr
\strong{Defaults to NULL (optional).}
}}

\item{binomial}{Binomial columns in \code{data} to be aggregated.
\strong{Defaults to \code{NULL} (optional).}}
}
\value{
A single-row data frame (tibble) containing:
\itemize{
\item A column \code{n} with the total number of rows in the input data.
\item For each specified column in \code{gaussian}, \code{binomial}, a corresponding
\emph{list-column} (named e.g., \code{colname_gaussian}, \code{colname_binomial}.
Each element of these list-columns can be accessed by using the \code{$} operator twice, e.g. through \code{data$colname_gaussian$Y1} for the first element of the Gaussian summary.
}
}
\description{
Aggregates specified columns of a data frame into summarizing statistics,
preserving the potentially complex structure returned by aggregator functions
(like data frames or inla.mdata objects) within list-columns.
Aggregation is performed according to sufficient statistics for the specified
distribution of the columns. Possible distributions: Gaussian, binomial.
This function aggregates the entire data frame into a single row result.
}
