% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CUTOFF.R
\name{CUTOFF}
\alias{CUTOFF}
\title{Returns the superiority or futility cutoff during a MABOUST trial.}
\usage{
CUTOFF(Delta, n, nTreat, nCat, gamma)
}
\arguments{
\item{Delta}{Value of \eqn{\Delta} to test.}

\item{n}{Current sample size in the trial.}

\item{nTreat}{Number of active treatments in consideration, i.e. 1,...,K.}

\item{nCat}{Number of ordinal outcome categories, i.e. J.}

\item{gamma}{Length 3 vector of cutoff parameters.}
}
\value{
The set of active treatments to continue, an optimal treatment, or a set of equally optimal treatments. Also reports posterior mean utilities and ordinal outcome probabilities as well as pairwise comparisons of utility similarity, when appropriate.
}
\description{
Returns the superiority or futility cutoff during a MABOUST trial.
}
\examples{
###Trial parameters
nCat = 6
nTreat = 3
Delta=5
n=300
###Design parameters
gamma= c(.5, .05, .05)
CUTOFF(Delta,n,nTreat,nCat,gamma)
}
\references{
[1] Chapple and Clement (2020), MABOUST: A Multi-Armed Bayesian Ordinal Outcome Utility-Based Sequential Trial. Submitted.
}
