% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_selection.R
\name{feature_selection}
\alias{feature_selection}
\title{Select the cluster related features via hypergeometric test}
\usage{
feature_selection(
  X,
  clusters,
  z_score = FALSE,
  upper_bound,
  lower_bound,
  p.adjust.method = "BH"
)
}
\arguments{
\item{X}{the feature matrix to be analyzed, with rows as samples and columns as features}

\item{clusters}{the numeric cluster results with number specifying the cluster}

\item{z_score}{a binary value to specify whether to calculate z-score for X first}

\item{upper_bound}{values larger than this value should be treated as over-expressed}

\item{lower_bound}{values smaller than this value should be treated as under-expressed}

\item{p.adjust.method}{the p value adjust method, defalut as 'BH'}
}
\value{
results, a list, which is as long as (cluster number+2), with the first (cluster number) element
as two sub-list, each composing a feature vector and a FDR vector. The last two elements are two matrices,
one is the matrix representing the fraction of over-express samples in each cluster for each features , and
the other represents that of under-express.
}
\description{
Select the cluster related features via hypergeometric test
}
\examples{
library(InterSIM)
sim.data <- InterSIM(n.sample=500, cluster.sample.prop = c(0.20,0.30,0.27,0.23),
delta.methyl=5, delta.expr=5, delta.protein=5,p.DMP=0.2, p.DEG=NULL,
p.DEP=NULL,sigma.methyl=NULL, sigma.expr=NULL, sigma.protein=NULL,cor.methyl.expr=NULL,
cor.expr.protein=NULL,do.plot=FALSE, sample.cluster=TRUE, feature.cluster=TRUE)
sim.methyl <- sim.data$dat.methyl
sim.expr <- sim.data$dat.expr
sim.protein <- sim.data$dat.protein
temp_data <- list(sim.methyl, sim.expr, sim.protein)
M3JF_res <- M3JF(temp_data,k=4)
feature_list <- feature_selection(temp_data[[1]],M3JF_res$cluster_res,z_score=TRUE,
upper_bound=1, lower_bound=-1)
}
