% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{func_li08}
\alias{func_li08}
\title{Example ODE function: bacterial cell cycle.}
\format{
R file with definition of function func_li08 that takes as
input arguments time t (dimension 1), and variable values y (dimension 18).
the kinetic parameters are defined within the function.
}
\source{
The Caulobacter cell cycle model was proposed in 
Li S, Brazhnik P, Sobral B, Tyson JJ. A Quantitative Study of the 
Division Cycle of Caulobacter crescentus Stalked Cells. Plos Comput Biol. 
2008;4(1):e9. The function corresponds to the MATLAB function modelwtin(t,y)
as given on \url{http://mpf.biol.vt.edu/research/caulobacter/SWST/pp/}.
}
\usage{
func_li08
}
\description{
The file contains the function definition an ordinary differential equation
model of Caulobacter crescentus cell cycle as proposed by Li et al., 2008. 
It has 18 variables.
}
\details{
The Caulobacter cell cycle model function will only give the solution as 
shown in the publication [Li et al., 2008] if the change in variables at 
defined events are taken into account. Please refer to the original 
reference for details.
}
\keyword{datasets}
