% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copula_additive.R
\name{copula_additive}
\alias{copula_additive}
\title{Copula regression models with semiparametric additive hazards margins for bivariate interval censoring and semi-competing risks.}
\source{
Tao Sun, Huiping Zheng, and Xiaojun Wang (2025+).
Decomposing Differences in Cohort Health Expectancy by Cause and Age with Longitudinal Data.
Under review. \cr
}
\usage{
copula_additive(
  data,
  var_list,
  l1 = 0,
  u1,
  m1 = 3,
  l2 = 0,
  u2,
  m2 = 3,
  method = "Newton",
  iter = 1000,
  stepsize = 1e-05,
  hes = TRUE,
  control = list(),
  eta_ini = NULL
)
}
\arguments{
\item{data}{a data frame; must have \code{id} (subject id), \code{visit} (the visit number for the subject),
\code{visit_time} (the time for each visit in years), \code{status} (the disability status at visit_time, 1 for disability, 0 for non-disability),
\code{statusD} (the death status at visit_time, 1 for dead, 0 for alive), and \code{weight} sampling weight and each subject received the same weight across visits.}

\item{var_list}{the list of covariates to be fitted into the copula model.}

\item{l1}{Left boundary of event 1 time interval.}

\item{u1}{Right boundary of event 1 time interval.}

\item{m1}{Degree of Bernstein polynomial for event 1.}

\item{l2}{Left boundary of event 2 time interval.}

\item{u2}{Right boundary of event 2 time interval.}

\item{m2}{Degree of Bernstein polynomial for event 2.}

\item{method}{optimization method (see \code{?optim}); default is \code{"BFGS"};
also can be \code{"Newton"} (see \code{?nlm}).}

\item{iter}{number of iterations when \code{method = "Newton"};
default is 300.}

\item{stepsize}{size of optimization step when method is \code{"Newton"};
default is 1e-6.}

\item{hes}{default is \code{TRUE} for hessian calculation;
if LRT is desired, can set \code{hes = FALSE} to save time.}

\item{control}{a list of control parameters for methods other than \code{"Newton"};
see ?optim.}

\item{eta_ini}{Optional initial values for copula parameters.}
}
\value{
a \code{LongDecompHE} object summarizing the model.
Can be used as an input to general \code{S3} methods including
\code{summary}, \code{print}, \code{plot},
\code{coef}, \code{logLik}, \code{AIC}.
}
\description{
Fits a copula model with semiparametric additive hazards marginsfor bivariate interval censoring and semi-competing risks.
}
\details{
must have \code{id} (subject id), \code{visit} (the visit number for the subject),
\code{visit_time} (the time for each visit in years), \code{status} (the disability status at visit_time, 1 for disability, 0 for non-disability),
\code{statusD} (the death status at visit_time, 1 for dead, 0 for alive),
and \code{weight} sampling weight and each subject received the same weight across visits. \cr


Optimization methods can be all methods (except \code{"Brent"}) from \code{optim}, such as
\code{"Nelder-Mead"}, \code{"BFGS"}, \code{"CG"}, \code{"L-BFGS-B"}, \code{"SANN"}.
Users can also use \code{"Newton"} (from \code{nlm}).
}
\examples{
# Fit a Copula2-Semiparametric additive hazards model
data(simulated_dataA)
u1 = u2 = max(simulated_dataA$visit_time)
var_list = c("Z1", "Z2", "Z3")
copula_additive_model <-  copula_additive(data = simulated_dataA,
                                        var_list = var_list,
                                        l1=0, u1 = u1, m1 = 3,
                                        l2=0, u2 = u2, m2 = 3,
                                        method = "combined", iter=1000,
                                        stepsize=1e-6,
                                        hes = TRUE,
                                        control = list(maxit = 10000))
summary(copula_additive_model)



}
