

######### pseudo-loglik for updating copula parameters based on marginal estimates ##########
# step 1b, additive hazards
ic_scmprisk_copula_log_lik_sieve_pseudo_addhaz_copula2_tvc <- function(p, fitted, x1_left, x1_right, x2_timeD, t1_left, t1_right, t2, indata1, indata2, bl1, br1, b2, b2_d, m1, m2, p1, p2, quantiles = NULL, copula, weight)
{

  if (copula != "Copula2") {

    eta <- (p[1]) # anti-log
    phi1 <- p[2:(1+1+m1)]
    beta1 <- p[(1+1+m1+1):length(p)]
    ep1 <- cumsum(exp(phi1))


    phi2 <- fitted[1:(1+m2)]
    beta2 <- fitted[(1+m2+1):length(fitted)] # coefficients
    ep2 <- cumsum(exp(phi2))

  }

  if (copula == "Copula2") {

    alpha <- exp(p[1])/(1+exp(p[1])) # anti-log
    kappa <- exp(p[2]) # anti-log
    phi1 <- p[3:(2+1+m1)]
    beta1 <- p[(2+1+m1+1):length(p)]
    ep1 <- cumsum(exp(phi1))

    phi2 <- fitted[1:(1+m2)]
    beta2 <- fitted[(1+m2+1):length(fitted)] # coefficients
    ep2 <- cumsum(exp(phi2))

  }

  # survival probability
  gLl1<- (x1_left%*%beta1) + (bl1%*%ep1) # AD, left end
  gLr1<- (x1_right%*%beta1) + (br1%*%ep1)
  if(length(beta2)==1){
    gL2 <- (x2_timeD[,1:p2] * beta2) + (b2%*%ep2)

    u1_left = exp(-gLl1)
    u1_right = exp(-gLr1)
    u2 = exp(-gL2)

    # derivative of survival (= negative density)
    u2_t2 <- u2 * (-1) * ((b2_d %*% ep2) + (x2_timeD[,(p2+1):(p2+p2)] * beta2))}
  else{
    gL2 <- (x2_timeD[,1:p2] %*% beta2) + (b2%*%ep2)

    u1_left = exp(-gLl1)
    u1_right = exp(-gLr1)
    u2 = exp(-gL2)

    # derivative of survival (= negative density)
    u2_t2 <- u2 * (-1) * ((b2_d %*% ep2) + (x2_timeD[,(p2+1):(p2+p2)] %*% beta2))
  }


  if (copula == "Copula2") {

    # Copula2 Copula function for joint distribution probability
    C_val_1 <- (1 + ((u1_left^(-1/kappa)-1)^(1/alpha) + (u2^(-1/kappa)-1)^(1/alpha))^alpha)^(-kappa)
    C_val_2 <- (1 + ((u1_right^(-1/kappa)-1)^(1/alpha) + (u2^(-1/kappa)-1)^(1/alpha))^alpha)^(-kappa)
    c_u2_val_1 <- C_val_1^(1+1/kappa) * (1 + ((u1_left^(-1/kappa)-1)/(u2^(-1/kappa)-1))^(1/alpha) )^(alpha-1)  * u2^(-1/kappa-1) # wrt to u2
    c_u2_val_2 <- C_val_2^(1+1/kappa) * (1 + ((u1_right^(-1/kappa)-1)/(u2^(-1/kappa)-1))^(1/alpha) )^(alpha-1)  * u2^(-1/kappa-1) # wrt to u2

    # C_val_A <- (1 + ((u1_A^(-1/kappa)-1)^(1/alpha) + (u2_A^(-1/kappa)-1)^(1/alpha))^alpha)^(-kappa)

  }



  if (copula == "Joe") {

    # Joe joint and density functions
    C_val_1 <- 1 - ( (1-u1_left)^(eta) + (1-u2)^(eta) - (1-u1_left)^(eta)*(1-u2)^(eta) )^(1/eta)
    C_val_2 <- 1 - ( (1-u1_right)^(eta) + (1-u2)^(eta) - (1-u1_right)^(eta)*(1-u2)^(eta) )^(1/eta)
    c_u2_val_1 <- ((1-u1_left)^eta + (1-u2)^eta - ((1-u1_left)^eta)*((1-u2)^eta) )^(1/eta - 1)  *  ((1-u2)^(eta-1) - (1-u2)^(eta-1)*(1-u1_left)^eta)
    c_u2_val_2 <- ((1-u1_right)^eta + (1-u2)^eta - ((1-u1_right)^eta)*((1-u2)^eta) )^(1/eta - 1)  *  ((1-u2)^(eta-1) - (1-u2)^(eta-1)*(1-u1_right)^eta)

    # C_val_A <- 1 - ( (1-u1_A)^(eta) + (1-u2_A)^(eta) - (1-u1_A)^(eta)*(1-u2_A)^(eta) )^(1/eta)

  }


  if (copula == "Gumbel") {

    C_val_1 <- exp(-((-log(u1_left))^eta + (-log(u2))^eta)^(1/eta))
    C_val_2 <- exp(-((-log(u1_right))^eta + (-log(u2))^eta)^(1/eta))
    c_u2_val_1 <- gh_F(u1_left,u2,eta)*((-log(u1_left))^eta+(-log(u2))^eta)^(1/eta-1)*(-log(u2))^(eta-1)/u2
    c_u2_val_2 <- gh_F(u1_right,u2,eta)*((-log(u1_right))^eta+(-log(u2))^eta)^(1/eta-1)*(-log(u2))^(eta-1)/u2

    # C_val_A <- exp(-((-log(u1_A))^eta + (-log(u2_A))^eta)^(1/eta))

  }


  if (copula == "AMH") {

    # AHM joint and desity functions
    C_val_1 <- u1_left * u2 /(1 - eta * (1-u1_left) * (1-u2))
    C_val_2 <- u1_right * u2 /(1 - eta * (1-u1_right) * (1-u2))
    c_u2_val_1 <- u1_left*(1-eta*(1-u1_left))/(1-eta*(1-u1_left)*(1-u2))^2
    c_u2_val_2 <- u1_right*(1-eta*(1-u1_right))/(1-eta*(1-u1_right)*(1-u2))^2

    # C_val_A <- u1_A * u2_A /(1 - eta * (1-u1_A) * (1-u2_A))

  }


  if (copula == "Frank") {

    C_val_1 <- 1/((-1) * eta) * log(1 + (exp((-1) * eta*u1_left)-1)*(exp((-1) * eta*u2)-1)/(exp((-1) * eta)-1))
    C_val_2 <- 1/((-1) * eta) * log(1 + (exp((-1) * eta*u1_right)-1)*(exp((-1) * eta*u2)-1)/(exp((-1) * eta)-1))
    c_u2_val_1 <- (exp((-1) * eta*u1_left)-1)*exp((-1) * eta*u2)/((1 + (exp((-1) * eta*u1_left)-1)*(exp((-1) * eta*u2)-1)/(exp((-1) * eta)-1))*(exp((-1) * eta)-1))
    c_u2_val_2 <- (exp((-1) * eta*u1_right)-1)*exp((-1) * eta*u2)/((1 + (exp((-1) * eta*u1_right)-1)*(exp((-1) * eta*u2)-1)/(exp((-1) * eta)-1))*(exp((-1) * eta)-1))

    # C_val_A <- 1/((-1) * eta) * log(1 + (exp((-1) * eta*u1_A)-1)*(exp((-1) * eta*u2_A)-1)/(exp((-1) * eta)-1))

  }


  if (copula == "Clayton") {

    C_val_1 <-(u1_left^(-eta)+u2^(-eta)-1)^(-1/eta)
    C_val_2 <-(u1_right^(-eta)+u2^(-eta)-1)^(-1/eta)
    c_u2_val_1 <- u2^(-eta-1)*(u1_left^(-eta)+u2^(-eta)-1)^(-1/eta-1)
    c_u2_val_2 <- u2^(-eta-1)*(u1_right^(-eta)+u2^(-eta)-1)^(-1/eta-1)

    # C_val_A <-(u1_A^(-eta)+u2_A^(-eta)-1)^(-1/eta)

  }


  # Use Copula functions to write each block of likelihood function
  term1 <- ifelse((indata1[,"status"] == 0) & (indata2[,"statusD"] == 0), C_val_1, 1)
  term1 <- log(abs(term1))

  term2 <- C_val_1 - C_val_2
  term2 <- ifelse((indata1[,"status"] == 1) & (indata2[,"statusD"] == 0), term2, 1)
  term2 <- log(abs(term2))

  term3 <- (c_u2_val_1 - c_u2_val_2) * (-u2_t2)
  term3 <- ifelse((indata1[,"status"] == 1) & (indata2[,"statusD"] == 1), term3, 1)
  term3[term3 < 0] <- 1
  term3 <- log(abs(term3))

  term4 <- (c_u2_val_1) * (-u2_t2)
  term4 <- ifelse((indata1[,"status"] == 0) & (indata2[,"statusD"] == 1), term4, 1)
  term4[term4 < 0] <- 1
  term4 <- log(abs(term4))

  # # left truncation
  # term5 <- ifelse((indata1[, "A1"] == 0), u2_A, C_val_A) # A1 = 0 means S(A1, A2) = S(0, A2) = S2(A2)
  # term5 <- ifelse((indata1[, "A1"] == 0) & (indata2[, "A2"] == 0), 1, term5) # A1 = A2 = 0 means S(0, 0) = 1
  # term5 <- log(abs(term5))


  # logL<-(-1)*sum( term1 + term2 + term3 + term4 - term5)

  logL<-(-1)*sum( weight * (term1 + term2 + term3 + term4))
  return(logL)
}



