% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateLobsterMovement.R
\name{SimulateLobsterMovement}
\alias{SimulateLobsterMovement}
\title{Function to run the simulation based on defined parameters}
\usage{
SimulateLobsterMovement(p)
}
\arguments{
\item{p}{is a list of all input variables}
}
\value{
Returns a list
}
\description{
Function to run the simulation based on defined parameters
}
\examples{
p = list()
p$nrowgrids = 10
p$ncolgrids = 10
p$ngrids = p$nrowgrids * p$ncolgrids
p$unitarea = 1
p$initlambda = 0.5
p$dStep = 1
p$howClose = 1
p$initD = 1
p$shrinkage = 0.993
p$currentZoI = 15
p$radiusOfInfluence = 15
p$q0 = 0.5
p$qmin = 0
p$Trap = data.frame( x = c(5), y = c(5) )
p$ntraps = nrow(p$Trap)
p$saturationThreshold = 5
p$lengthBased = FALSE
p$lobsterSizeFile =
'https://raw.githubusercontent.com/vpourfaraj/lobsterCatch/main/inst/extdata/LobsterSizeFreqs.csv'
p$lobLengthThreshold = 115
p$trapSaturation = FALSE
p$sexBased = FALSE
p$lobsterSexDist = list(labels = c('M','F','MM','BF'),
                        prob1 = c(0.55,0.35,0.05,0.05),
                        prob2 = c(0.5,0.50,0,0),
                        lobsterMatThreshold = 100)
p$realizations = 2
p$tSteps = 2
Simrun = SimulateLobsterMovement(p)
}
\seealso{
Examples of the input parameters and more details can be found here: https://github.com/pnickchi/lobstercatch/blob/main/Examplecode.R
}
