% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_main.R
\name{LoTTA_sharp_BIN}
\alias{LoTTA_sharp_BIN}
\title{LoTTA_sharp_BIN}
\usage{
LoTTA_sharp_BIN(
  x,
  y,
  c,
  ci = 0.95,
  trimmed = NULL,
  outcome_prior = list(pr = 1e-04),
  n_min = 25,
  param = c("eff", "a0l", "a1l", "a2l", "a3l", "a0r", "a1r", "a2r", "a3r", "kl", "kr"),
  normalize = TRUE,
  n.chains = 4,
  burnin = 5000,
  sample = 5000,
  adapt = 1000,
  inits = NULL,
  method = "parallel",
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{\itemize{
\item is the score data
}}

\item{y}{\itemize{
\item is the binary outcome data
}}

\item{c}{\itemize{
\item specifies the cutoff point
}}

\item{ci}{\itemize{
\item specifies the probability level 1-alpha for the highest posterior density intervals; default is ci = 0.95
}}

\item{trimmed}{\itemize{
\item takes as a value NULL or a vector of two values. It specifies potential trimming of the data.
If set to NULL no trimming is applied to the data. If a list of two values is provided the data is trimmed
to include data points with the score x in between those values; deafult is trimmed=NULL
}}

\item{outcome_prior}{\itemize{
\item takes as a value a list with elements 'pr'. 'pr' specifies precision in the normal priors on the coefficients in the
outcome function; default is list('pr'=0.0001)
}}

\item{n_min}{\itemize{
\item specifies the minimum number of data points to which a cubic part of the outcome function is fit to ensure stability of the sampling procedure; default is n_min=25
}}

\item{param}{\itemize{
\item takes as a value a vector with names of the parameters that are to be sampled; default is the list of all parameters
}}

\item{normalize}{\itemize{
\item specifies if the data is to be normalized. The data is normalized as follows. x_normalized=(x-d)/s, where d=(min(x)+max(x))*0.5 and s=max(x)-min(x).
The priors inside the model are specified for the normalized data, in extreme cases not normalizing the data may lead to unreliable results; default is normalize=TRUE
}}

\item{n.chains}{\itemize{
\item specifies the number of chains in the MCMC sampler; default is n.chains=4
}}

\item{burnin}{\itemize{
\item specifies the number of burnin iterations without the adaptive iterations; default is burnin=5000
}}

\item{sample}{\itemize{
\item specifies the number of samples per chain; default is samples=5000
}}

\item{adapt}{\itemize{
\item specifies the number of adaptive iterations in the MCMC sampler; default is adapt=1000
}}

\item{inits}{\itemize{
\item initial values for the sampler. By default the initial values are sampled inside the function. To run LoTTA with a method other than "parallel" inits must be set to NA or to a user defined value.
If the user wants to provide its own values please refer to run.jags manual; default inits=NULL
}}

\item{method}{\itemize{
\item set to default as 'parallel', which allows to sample the chains in parallel reducing computation time.
To read more about possible method values type ?run.jags; default method='parallel'
}}

\item{seed}{\itemize{
\item specifies the seed for replicability purposes; default is seed=NULL
}}

\item{...}{\itemize{
\item other arguments of run.jags function. For more details type ?run.jags
}}
}
\value{
The function returns the list with the elements:
\itemize{
\item Effect_estimate: contains a list with MAP estimate and HDI of the treatment effect on the original, unnormalized scale;
\item JAGS_output: contains output of the run.jags function for the normalized data if normalize=TRUE, based on this output mixing of the chains can be assessed;
\item Samples: contains posterior samples of the treatment effect (eff);
\item Normalized_data: contains a list of the normalized data (if normalized=TRUE) and the parameters used to normalize the data (see arg normalize);
\item Priors: contains a list of the outcome prior parameters ;
\item Inits contains the list of initial values  and .RNG.seed value
}
}
\description{
Function that fits LoTTA model to the sharp RD data with binary outcomes. The score does NOT have to be normalized
beforehand. We recommend NOT to transform the data before imputing it into the function, except for initial trimming of the score which should be done beforehand.
The further trimming for the sensitivity analysis can be done through the function, which ensures that the data is normalized before the trimming.
}
\examples{
# functions to generate the data

ilogit <- function(x) {
  return(1 / (1 + exp(-x)))
}

fun_prob55 <- function(x) {
  P = rep(0, length(x))
  P[x >= 0.] = ilogit((8.5 * x[x >= 0.] - 1.5)) / 10.5 + 0.65 - 0.0007072
  P[x < 0.] = (x[x < 0.] + 1)^4 / 15 + 0.05
  return(P)
}

sample_prob55 <- function(x) {
  P = rep(0, length(x))
  P[x >= 0.] = ilogit((8.5 * x[x >= 0.] - 1.5)) / 10.5 + 0.65 - 0.0007072
  P[x < 0.] = (x[x < 0.] + 1)^4 / 15 + 0.05
  t = rep(0, length(x))
  for (j in 1:length(x)) {
    t[j] = sample(c(1, 0), 1, prob = c(P[j], 1 - P[j]))
  }
  return(t)
}

## Toy example - for the function check only! ##
# data generation
N=100
x = sort(runif(N, -1, 1))
y = sample_prob55(x)
c = 0

# running LoTTA model on a sharp RDD with a binary outcome
out = LoTTA_sharp_BIN(x, y, c, burnin = 50, sample = 50, adapt = 10,n.chains=1
                      ,method = 'simple',inits = NA)

## Use case example ##
\donttest{
  # data generation
  N=1000 # try different dataset size
  x = sort(runif(N, -1, 1))
  y = sample_prob55(x)
  c = 0

  # running LoTTA function on sharp RDD with binary outcomes;
  # cutoff = 0, treatment effect = 0.55
  # remember to check convergence and adjust burnin, sample and adapt if needed
  out = LoTTA_sharp_BIN(x, y, c, burnin = 10000, sample = 5000, adapt = 1000,n.chains=4)
  # print effect estimate:
  out$Effect_estimate
  # print JAGS output to asses convergence (the output is for normalized data)
  out$JAGS_output
  # plot posterior fit
  LoTTA_plot_outcome(out,nbins = 60)
}
}
