% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dedup_refs.R
\name{dedup_refs}
\alias{dedup_refs}
\title{Deduplicates the references from up to three dataframes.}
\usage{
dedup_refs(
  df1 = NULL,
  df2 = NULL,
  df3 = NULL,
  directory,
  open_file = FALSE,
  dry_run = FALSE
)
}
\arguments{
\item{df1}{Dataframe 1 (can be NULL)}

\item{df2}{Dataframe 2 (can be NULL)}

\item{df3}{Dataframe 3 (can be NULL)}

\item{directory}{Choose the directory in which
the references deduplication history will be saved.}

\item{open_file}{Automatically opens the CSV file after reference retrieval.}

\item{dry_run}{Simulation run option.}
}
\value{
\code{NULL} (invisibly). Called for its side effects:
writes a CSV of deduplicated citations and
an Excel workbook recording the deduplication history.
}
\description{
Deduplicates the references from up to three dataframes.
}
\examples{
# This is a "dry run" example.
# No deduplication will happen.
# It only shows how the function should react.
dedup_refs(df1 = df_vibrio_wos,
           df2 = df_vibrio_scp,
           df3 = df_vibrio_pmd,
           directory = tempdir(),
           open_file = FALSE,
           dry_run = TRUE
           )

}
