% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{alphaopic.action.spectra}
\alias{alphaopic.action.spectra}
\title{Alphaopic (+ photopic) action spectra}
\format{
\code{alphaopic.action.spectra} A datafram with 471 rows and 7 columns:
\describe{
\item{wavelength}{integer of wavelength, from 360 to 830 nm. Unit is nm}
\item{melanopic}{numeric melanopic action spectrum}
\item{l_cone_opic}{numeric L-cone opic action spectrum}
\item{m_cone_opic}{numeric M-cone opic action spectrum}
\item{s_cone_opic}{numeric S-cone opic action spectrum}
\item{rhodopic}{numeric rhodopic action spectrum}
\item{photopic}{numeric photopic action spectrum}
}
}
\source{
\url{https://www.cie.co.at/publications/cie-system-metrology-optical-radiation-iprgc-influenced-responses-light-0}

\url{https://cie.co.at/datatable/cie-spectral-luminous-efficiency-photopic-vision}

<https://files.cie.co.at/CIE S 026 alpha-opic Toolbox.xlsx>
}
\usage{
alphaopic.action.spectra
}
\description{
A dataframe of alphaopic action spectra plus the photopic action spectrum.
The alphaopic action spectra are according to the \href{https://www.cie.co.at/publications/cie-system-metrology-optical-radiation-iprgc-influenced-responses-light-0}{CIE S 026/E:2018}
standard. The alphaopic action spectra are for a 32-year-old standard
observer. The photopic action spectrum is for a 2° standard observer.
}
\references{
CIE (2019). ISO/CIE 11664-1:2019(E). Colorimetry — Part 1: CIE
standard colorimetric observers. Vienna, CIE

CIE (2018). CIE S 026/E:2018. CIE system for metrology of optical
radiation for ipRGC-influenced responses of light. Vienna, CIE
}
\keyword{datasets}
