% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.simu.data.R
\name{gen.simu.data}
\alias{gen.simu.data}
\title{A Bootstrap Proportion Test for Brand Lift Testing (Liu et al., 2023)}
\usage{
gen.simu.data(n1, n2, p1, p2, summary=TRUE)
}
\arguments{
\item{n1}{sample size of the control group}

\item{n2}{sample size of the treatment group}

\item{p1}{success probability of the control group}

\item{p2}{success probability of the treatment group}

\item{summary}{boolean variable. if TRUE it returns 2x2 contingency table; if FALSE it returns raw binomial random samples.
By default, summary=TRUE.}
}
\value{
A list of simulated data for the control group and the treatment group if \emph{summary=FALSE} or
a 2x2 contingency table if \emph{summary=TRUE}
}
\description{
This function generates binomial random samples for the control group
(with sample size \eqn{n_1} and success probability \eqn{p_1}) and the treatment
group (with sample size \eqn{n_2} and success probability \eqn{p_2}).
}
\details{
The a 2x2 contingency table is of the following form\tabular{ll}{
   col1 \tab col 2 \cr
   control sample size \tab control positive response count \cr
   treatment sample size \tab treatment positive response count \cr
}
}
\examples{
n1 <- 100; n2 <- 100; p1 <- 0.1; p2 <- 0.2
set.seed(1)
sim.data <- gen.simu.data(n1, n2, p1, p2)
sim.data
}
