% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexis_polygon.R
\name{lexis_polygon}
\alias{lexis_polygon}
\title{Plot a polygon inside a Lexis grid
Takes an existing Lexis grid and adds a polygon.}
\usage{
lexis_polygon(lg, x, y, group = 1, fill = lexisplotr_colours()[4],
  alpha = 0.7)
}
\arguments{
\item{lg, }{an existing object originally created with \code{lexis_grid()}.}

\item{x, }{vector describing the x coordinates of the polygon. Format: YYYY-MM-DD.}

\item{y, }{vector describing the y coordinates of the polygon}

\item{group, }{vector describing the groups of coordinates.}

\item{fill}{character, fill colour of the polygon.}

\item{alpha}{numeric, transparency of the fill colour. Default: 0.7.}
}
\description{
Plot a polygon inside a Lexis grid
Takes an existing Lexis grid and adds a polygon.
}
\details{
The function can be used to plot a polygon inside a Lexis grid.
}
\examples{
\dontrun{
library(LexisPlotR)
lg <- lexis_grid(year_start = 1900, year_end = 1905, age_start = 0, age_end = 5)
lexis_polygon(lg, x = c("1901-06-30", "1904-06-30", "1904-06-30", "1901-06-30"), y = c(2,2,4,4))
}
}
\author{
Philipp Ottolinger
}
