% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal.R
\name{plotNorm}
\alias{plotNorm}
\title{Density Function, Distribution Function and/or
Quantile Function Representations associated with a Normal Distribution}
\usage{
plotNorm(mu, sigma, type = "b", col = "black")
}
\arguments{
\item{mu}{the mean of the Normal distribution.}

\item{sigma}{the standard deviation of the Normal distribution.}

\item{type}{a character string giving the type of desired plot. The following values are possible:
"b" (default) for density function, distribution function and quantile function representations together,
"dis" for distribution function representation,
"den" for density function representation and "q" for quantile function representation.}

\item{col}{a single colour associated with the different representations; default to "black".}
}
\value{
This function is called for the side effect of drawing the plot.
}
\description{
\code{plotNorm} represents density, distribution and/or quantile functions associated with a Normal
 distribution with certain parameters \code{mu} and \code{sigma}.
}
\examples{
mu=10; sigma=5
plotNorm(mu,sigma)
plotNorm(mu,sigma,col="red")
plotNorm(mu,sigma,type="q")
plotNorm(mu,sigma,type="dis")
plotNorm(mu,sigma,type="den")
}
