% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sierpinski.R
\name{Sierpinski}
\alias{Sierpinski}
\title{Plots the Sierpinski triangle}
\usage{
Sierpinski(Tri, it)
}
\arguments{
\item{Tri}{Regular triangle, previously created with function \code{CreateRegularPolygon}}

\item{it}{Number of iterations to be performed for the construction of Sierpinski triangle. It is not recommended to choose a number higher than 10 in order to avoid an excess of computation}
}
\value{
None. It produces the plot of the first \code{n} iterations of Sierpinski triangle in the current coordinate plane
}
\description{
\code{Sierpinski} plots the first iterations of Sierpinski triangle, a well-known fractal
}
\examples{
x_min <- -6
x_max <- 6
y_min <- -6
y_max <- 6
CoordinatePlane(x_min, x_max, y_min, y_max)
n <- 3
C <- c(0,0)
l <- 5
Tri <- CreateRegularPolygon(n, C, l)
it <- 6
Sierpinski(Tri, it)
}
\references{
http://mathworld.wolfram.com/SierpinskiSieve.html
}
