% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agglomerativeHC.details.R
\name{agglomerativeHC.details}
\alias{agglomerativeHC.details}
\title{To explain agglomerative hierarchical clusterization algorithm by distance and approach.}
\usage{
agglomerativeHC.details(data, distance, approach)
}
\arguments{
\item{data}{could be a numeric vector, a matrix or a numeric data frame. It will be transformed into matrix and list to be used.}

\item{distance}{is a string. It chooses the distance to use.}

\item{approach}{is a string. It chooses the approach to use.}
}
\value{
agglomerative algorithm explanation.
}
\description{
To explain the complete agglomerative hierarchical clusterization algorithm choosing distance and approach type.
}
\details{
This function is the main part of the agglomerative hierarchical clusterization method.
It explains the theoretical algorithm step by step.

1 - The function transforms data into useful object to be used.

2 - It creates the clusters.

3 - It calculates a matrix distance with the clusters created by applying the distance and the approach given.

4 - It chooses the distance value and gets the clusters.

5 - It groups the clusters in a new one and updates clusters list.

6 - It repeats these steps until an unique cluster exists.
}
\examples{

a <- c(1,2,1,3,1,4,1,5,1,6)

matrixA <- matrix(a,ncol=2)

dataFrameA <- data.frame(matrixA)

agglomerativeHC.details(a,'EUC','MAX')

agglomerativeHC.details(matrixA,'MAN','AVG')

agglomerativeHC.details(dataFrameA,'CAN','MIN')

}
\author{
Roberto Alcántara \email{roberto.alcantara@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
