% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadImage.R
\name{startweb.esttest}
\alias{startweb.esttest}
\title{Opens default web browser and loads a web page for length estimation and
testing.}
\usage{
startweb.esttest()
}
\description{
Function \code{startweb.esttest()} opens a web browser and loads the page
for length estimation and hypothesis testing of data read from a picture.
Use this function if you would like to compute the length of an interval,
which is the domain of uniform distribution, but the data are contaminated
with additive error. Sequence of actions on the web page is as follows:
\enumerate{
 \item Load a picture in JPG format
 \item Click on start and end point of the line passing through the observed
   object
 \item Set data preparation parameters
 \item Click on generate data so the data are prepared
 \item \itemize{
   \item set estimation parameters (see \code{\link{lengthest}}) and click
     on Estimate, or
   \item set testing parameters (see \code{\link{lengthtest}}) and click on
     Test.
   }
 }
}
\details{
Parameters that can be set on the web page are as follows:

\strong{Data parameters}
 \describe{
   \item{Levels of grey}{Number of colors (shades of grey) used in analysis.}
   \item{Box size}{The algorithm takes each pixel of a picture and maps it
     to box_size * box_size matrix. It is done in a way that the brightness
     of the observed pixel dictates the quantity of \emph{dots} in mentioned
     matrix. Distribution of dots in matrix is uniform. Ultimately, length
     estimation or testing is done on the set of the resulting matrices.}
   \item{Line thickness}{Width of the line, i.e. the maximum length between
     surrounding pixel and the drawn line so that pixel is to be taken into
     account for length estimation or hypothesis testing. All surrounding
     pixels are orthogonally projected on the line.}
   \item{Observed object is...}{Sets whether observed object is bright or
     dark.}
 }
 \strong{Estimation parameters}
 \describe{
   \item{Error distribution}{The type of the error distribution. Can be
     Gauss, Laplace, T1, T2, T3, T4 or T5 (Student).}
   \item{Error standard deviation}{Estimation method for the error
     standard deviation. Can be Maximum Likelihood (ML) or the Method of
     Moments. If one does not want to estimate the deviation but to
     explicitly enter it, he should choose "Enter value" and enter the
     deviation in the lower field.}
   \item{Confidence level}{Confidence level of the confidence interval.}
 }
 \strong{Testing parameters}
 \describe{
   \item{\eqn{latex}{H_0}}{Specified null value being tested (measured in
     pixel width or percentage of image width).}
   \item{Alternative}{The alternative hypothesis. Can be less, greater or
     two-sided.}
 }
 \strong{Results}
 \itemize{
   \item Length expressed in pixel width, as well as in percentage of the
     whole image's width
   \item Standard deviation
   \item Method - Asymptotic distribution of MLE or LR statistic
   \item Confidence interval
   \item p-value of the test and the value of the test statistic (if
     hypothesis testing has been performed)
 }
}
\section{Note}{

In order to have quadratic pixels on the screen, please use proportional
screen resolution. In the case of modern LCD (LED) displays, these are
usually native screen resolutions. If your display has aspect ratio
width:height = 16:9, these resolutions are 1280x720, 1600x900, 1920x1080,
etc. In the case od 16:10 display, use 1280x800, 1440x900, 1920x1200, etc.
If you use nonproportional screen resolution, pixels on the screen will not
be quadratic, so estimated values measured in pixels may not be correct.
}

\examples{
# open the web page for length estimation and hypothesis testing of an
# object shown in the picture
\donttest{startweb.esttest()}

}
