% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lengthtest.R
\name{lengthtest}
\alias{lengthtest}
\title{Test for uniform distribution width.}
\usage{
lengthtest(x, error = c("laplace", "gauss", "t1", "t2", "t3", "t4",
  "t5"), alternative = c("two.sided", "greater", "less"), sd = NULL,
  null.a = NULL, sd.est = c("MM", "ML"), conf.level = 0.95)
}
\arguments{
\item{x}{Vector of input data}

\item{error}{A character string specifying the error distribution. Must be
one of "laplace", "gauss", "t1", "t2", "t3", "t4", "t5". Can be
abbreviated.}

\item{alternative}{A character string specifying the alternative hypothesis,
must be one of "two.sided", "greater" or "less". Can be abbreviated.}

\item{sd}{Explicit error standard deviation. Needs to be given if
\code{var.sd} is not given.}

\item{null.a}{Specified null value being tested.}

\item{sd.est}{A character string specifying the method of error standard
deviation estimation. Must be given if \code{sd} is not given. Can be "MM"
(Method of Moments) or "ML" (Maximum Likelihood).}

\item{conf.level}{Confidence level of the confidence interval.}
}
\value{
List containing:
  \itemize{
    \item error.type: A character string describing the type of the
      error distribution,
    \item radius: Estimated half-width of uniform distribution,
    \item sd.error: Error standard deviation, estimated or given,
    \item conf.level: Confidence level of the confidence interval,
    \item alternative: A character string describing the
      alternative hypothesis,
    \item method: A character string indicating what method for
      testing was used (asymptotic distribution of MLE or likelihood ratio
      statistic),
    \item conf.int: The confidence interval for half-width,
    \item null.a: null value being tested,
    \item p.value: p-value of the test,
    \item tstat: the value of the test statistic.
  }
}
\description{
Function \code{lengthtest()} tests the hypothesized uniform domain width
against two-sided or one-sided alternatives from data contaminated with
additive error. The additive error can be chosen as Laplace, Gauss or
scaled Student distribution with 1 - 5 degrees of freedom.
}
\examples{
# generate uniform data with additive error and run a hypothesis testing on it
sample_1 <- runif(1000, -1, 1)
sample_2 <- rnorm(1000, 0, 0.1)
sample <- sample_1 + sample_2
out <- lengthtest(x = sample, error = "gauss", alternative = "greater",
                  sd.est = "MM", null.a = 0.997, conf.level = 0.95)

}
