% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation.R
\name{estimateSpikes}
\alias{estimateSpikes}
\title{Estimate spike train, underlying calcium concentration, and changepoints based on fluorescence
trace.}
\usage{
estimateSpikes(dat, gam, lambda, type = "ar1", calcFittedValues = TRUE,
  hardThreshold = FALSE)
}
\arguments{
\item{dat}{fluorescence data}

\item{gam}{a scalar value for the AR(1)/AR(1) + intercept decay parameter.}

\item{lambda}{tuning parameter lambda}

\item{type}{type of model, must be one of AR(1) 'ar1', AR(1) + intercept 'intercept'.}

\item{calcFittedValues}{TRUE to calculate fitted values.}

\item{hardThreshold}{boolean specifying whether the calcium concentration must be non-negative (in the AR-1 problem)}
}
\value{
Returns a list with elements:

\code{changePts} the set of changepoints

\code{spikes} the set of spikes

\code{fittedValues} estimated calcium concentration
}
\description{
Estimate spike train, underlying calcium concentration, and changepoints based on fluorescence
trace.
}
\details{
This algorithm solves the optimization problems

\strong{AR(1)-model:}
minimize_{c1,...,cT} 0.5 sum_{t=1}^T ( y_t - c_t )^2 + lambda sum_{t=2}^T 1_{c_t neq gamma c_{t-1} }
for the global optimum, where $y_t$ is the observed fluorescence at the tth
timepoint.

If hardThreshold = T then the additional constraint
c_t >= 0 is added to the optimzation problem above.

\strong{AR(1) with intercept:}
minimize_{c1,...,cT,b1,...,bT} 0.5 sum_{t=1}^T (y_t - c_t - b_t)^2 + lambda sum_{t=2}^T 1_{c_t neq gamma c_{t-1}, b_t neq b_{t-1} }
where the indicator variable 1_{(A,B)} equals 1 if the event A cup B holds, and equals zero otherwise.

See Jewell and Witten (2017) <arXiv:1703.08644>, section 2 and 5.

Note that "changePts" and "spikes" differ by one index due to a quirk of the conventions used in the changepoint literature and the definition of a spike.
}
\examples{

sim <- simulateAR1(n = 500, gam = 0.998, poisMean = 0.009, sd = 0.05, seed = 1)
plot(sim)

# AR(1) model

fit <- estimateSpikes(sim$fl, gam = 0.998, lambda = 1, type = "ar1")
plot(fit)
print(fit)

# AR(1) + intercept model
fit <- estimateSpikes(sim$fl, gam = 0.998, lambda = 1, type = "intercept")
plot(fit)
print(fit)

}
\seealso{
\strong{Estimate spikes:}
\code{\link{estimateSpikes}},
\code{\link{print.estimatedSpikes}},
\code{\link{plot.estimatedSpikes}}.

\strong{Cross validation:}
\code{\link{cv.estimateSpikes}},
\code{\link{print.cvSpike}},
\code{\link{plot.cvSpike}}.

\strong{Simulation:}
\code{\link{simulateAR1}},
\code{\link{plot.simdata}}.
}
