% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_LTFHPlus_input.R
\name{familywise_attach_attributes}
\alias{familywise_attach_attributes}
\title{Wrapper to attach attributes to family graphs}
\usage{
familywise_attach_attributes(
  family_graphs,
  fam_attr,
  fam_graph_col = "fam_graph",
  attached_fam_graph_col = "masked_fam_graph",
  fid = "fid",
  pid = "pid",
  cols_to_attach = c("lower", "upper"),
  proband_cols_to_censor = NA
)
}
\arguments{
\item{family_graphs}{tibble with family ids and family graphs}

\item{fam_attr}{tibble with attributes for each family member}

\item{fam_graph_col}{column name of family graphs in family_graphs. defailts to "fam_graph"}

\item{attached_fam_graph_col}{column name of the updated family graphs with attached attributes. defaults to "masked_fam_graph".}

\item{fid}{column name of family id. Typically contains the name of the proband that a family graph is centred on. defaults to "fid".}

\item{pid}{personal identifier for each individual in a family. Allows for multiple instances of the same individual across families. Defaults to "pid".}

\item{cols_to_attach}{columns to attach to the family graphs from fam_attr, typically lower and upper thresholds. Mixture input also requires K_i and K_pop.}

\item{proband_cols_to_censor}{Should proband's upper and lower thresholds be made uninformative? Defaults to TRUE. Used to exclude proband's information for prediction.}
}
\value{
tibble with family ids and an updated family graph with attached attributes. If lower and upper thresholds are specified, the input is ready for estimate_liability().
}
\description{
This function can attach attributes to family graphs, such as lower and upper thresholds, for each family member. This allows for personalised thresholds and other per-family specific attributes.
This function wraps around attach_attributes to ease the process of attaching attributes to family graphs in the standard format.
}
\examples{
# See Vignettes.
}
