% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLM_chat_session.R
\name{llm_chat_session}
\alias{llm_chat_session}
\alias{chat_session}
\alias{as.data.frame.llm_chat_session}
\alias{summary.llm_chat_session}
\alias{head.llm_chat_session}
\alias{tail.llm_chat_session}
\alias{print.llm_chat_session}
\title{Chat Session Object and Methods}
\usage{
chat_session(config, system = NULL, ...)

\method{as.data.frame}{llm_chat_session}(x, ...)

\method{summary}{llm_chat_session}(object, ...)

\method{head}{llm_chat_session}(x, n = 6L, width = getOption("width") - 15, ...)

\method{tail}{llm_chat_session}(x, n = 6L, width = getOption("width") - 15, ...)

\method{print}{llm_chat_session}(x, width = getOption("width") - 15, ...)
}
\arguments{
\item{config}{An \link{llm_config} \strong{for a generative model} (\code{embedding = FALSE}).}

\item{system}{Optional system prompt inserted once at the beginning.}

\item{...}{Default arguments forwarded to every \code{\link[=call_llm_robust]{call_llm_robust()}} call (e.g. \code{verbose = TRUE}).}

\item{x, object}{An \code{llm_chat_session} object.}

\item{n}{Number of turns to display.}

\item{width}{Character width for truncating long messages.}
}
\value{
For \code{chat_session()}, an object of class \strong{\code{llm_chat_session}}.
Other methods return what their titles state.
}
\description{
Create and interact with a stateful chat session object that retains
message history. This documentation page covers the constructor function
\code{chat_session()} as well as all S3 methods for the \code{llm_chat_session} class.
}
\details{
The \code{chat_session} object provides a simple way to hold a conversation with
a generative model. It wraps \code{\link[=call_llm_robust]{call_llm_robust()}} to benefit from retry logic,
caching, and error logging.
}
\section{How it works}{

\enumerate{
\item A private environment stores the running list of
\code{list(role, content)} messages.
\item At each \verb{$send()} the history is sent \emph{in full} to the model.
\item Provider-agnostic token counts are extracted from the JSON response.
}
}

\section{Public methods}{

\describe{
\item{\code{$send(text, ..., role = "user")}}{
Append a message (default role \code{"user"}), query the model,
print the assistant's reply, and invisibly return it.}
\item{\code{$send_structured(text, schema, ..., role = "user", .fields = NULL, .validate_local = TRUE)}}{
Send a message with structured-output enabled using \code{schema}, append the assistant's reply,
parse JSON (and optionally validate locally when \code{.validate_local = TRUE}),
returning the parsed result invisibly.}
\item{\code{$history()}}{Raw list of messages.}
\item{\code{$history_df()}}{Two-column data frame (\code{role}, \code{content}).}
\item{\code{$tokens_sent()}/\code{$tokens_received()}}{Running token totals.}
\item{\code{$reset()}}{Clear history (retains the optional system message).}
}
}

\examples{
if (interactive()) {
  cfg  <- llm_config("openai", "gpt-4o-mini")
  chat <- chat_session(cfg, system = "Be concise.")
  chat$send("Who invented the moon?")
  chat$send("Explain why in one short sentence.")
  chat           # print() shows a summary and first 10 turns
  summary(chat)  # stats
  tail(chat, 2)
  as.data.frame(chat)
}
}
\seealso{
\code{\link[=llm_config]{llm_config()}}, \code{\link[=call_llm]{call_llm()}}, \code{\link[=call_llm_robust]{call_llm_robust()}}, \code{\link[=llm_fn]{llm_fn()}}, \code{\link[=llm_mutate]{llm_mutate()}}
}
