% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDM_fun.R
\name{jaccard.mean}
\alias{jaccard.mean}
\title{Expected value of the Jaccard distance matrix}
\usage{
jaccard.mean(
  otu.table,
  rarefy.depth = min(rowSums(otu.table)),
  first.order.approx.only = FALSE
)
}
\arguments{
\item{otu.table}{the \code{n.obs} by \code{n.otu} matrix of read counts.}

\item{rarefy.depth}{rarefaction depth. The default is the minimum library size observed in the OTU table.}

\item{first.order.approx.only}{a logical value indicating whether to calculate the expected value 
using the first order approixmation by the delta method. 
The default is FALSE, using the second order approixmation.}
}
\value{
a list consisting of 
  \item{jac.mean.o1}{Expected Jaccard distance matrix by the first order approixmation.}
  \item{jac.mean.o2}{Expected Jaccard distance matrix by the second order approixmation.} 
  \item{jac.mean.sq.o1}{Expected squared Jaccard distance matrix by the first order approixmation.} 
  \item{jac.mean.sq.o2}{Expected squared Jaccard distance matrix by the second order approixmation.}
}
\description{
This function computes the expected value of the Jaccard distance matrix over rarefaction replicates.
}
\examples{
res.jaccard <- jaccard.mean( throat.otu.tab5 )
}
\author{
Yi-Juan Hu <yijuan.hu@emory.edu>, Glen A. Satten <gsatten@emory.edu>
}
\keyword{microbiome}
