% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTarg.r
\name{plotTarg}
\alias{plotTarg}
\title{Plot sampled length structure against target simulated size composition}
\usage{
plotTarg(
  LB_pars = NULL,
  LB_lengths = NULL,
  yr = 1,
  Cols = NULL,
  title = NULL,
  targtext = TRUE,
  size.axtex = 12,
  size.title = 14,
  scales = c("fixed", "free_x", "free_y", "free")
)
}
\arguments{
\item{LB_pars}{an object of class \code{'LB_pars'} that contains the life history and fishing information}

\item{LB_lengths}{an object of class \code{'LB_lengths'} that contains the observed size data}

\item{yr}{index for sampled length data (defaults to 1)}

\item{Cols}{optional character vector of colours for the plot}

\item{title}{character - optional title for plot}

\item{targtext}{logical - should the SPR target text be displayed as a subtitle?}

\item{size.axtex}{size of the axis text}

\item{size.title}{size of axis title}

\item{scales}{argument to ggplot2 function. Are scales shared across all facets
(the default, "fixed"), or do they vary across rows ("free_x"), columns ("free_y"),
or both rows and columns ("free")}
}
\value{
a ggplot object
}
\description{
A function that plots the observed size structure against the expected size composition at the target SPR
}
\author{
A. Hordyk
}
