% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_network}
\alias{plot_network}
\title{Create network visualization from results}
\usage{
plot_network(
  results,
  output_file = "network.png",
  width = 1200,
  height = 900,
  resolution = 120,
  top_n = 15,
  min_score = 1e-04,
  node_size_factor = 5,
  color_by = "type",
  title = "Network Visualization",
  show_entity_types = TRUE,
  label_size = 1,
  verbose = TRUE
)
}
\arguments{
\item{results}{The results to visualize}

\item{output_file}{Filename for the output PNG (default: "network.png")}

\item{width}{Width of the output image (default: 1200)}

\item{height}{Height of the output image (default: 900)}

\item{resolution}{Resolution of the output image (default: 120)}

\item{top_n}{Maximum number of results to include (default: 15)}

\item{min_score}{Minimum score threshold (default: 0.0001)}

\item{node_size_factor}{Factor for scaling node sizes (default: 5)}

\item{color_by}{Column to use for node colors (default: "type")}

\item{title}{Plot title (default: "Network Visualization")}

\item{show_entity_types}{Logical; if TRUE, show entity types (default: TRUE)}

\item{label_size}{Relative size for labels (default: 1.0)}

\item{verbose}{Logical; if TRUE, print status messages (default: TRUE)}
}
\value{
Invisible NULL (creates a file as a side effect)
}
\description{
This function creates a network visualization from ABC results.
}
