% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_data.R
\name{fit_data}
\alias{fit_data}
\title{Fit a LATER model to a single dataset or a pair of datasets.}
\usage{
fit_data(
  data,
  share_a = FALSE,
  share_sigma = FALSE,
  share_sigma_e = FALSE,
  with_early_component = FALSE,
  intercept_form = FALSE,
  use_minmax = FALSE,
  fit_criterion = "likelihood",
  jitter_settings = list(n = 7, prop = 0.5, seed = NA, processes = 2)
)
}
\arguments{
\item{data}{A data frame with columns \code{name} and \code{promptness}.}

\item{share_a, share_sigma, share_sigma_e}{If \code{FALSE} (the default), each
dataset has its own parameter. If \code{TRUE}, the datasets share the relevant
parameter.}

\item{with_early_component}{If \code{TRUE}, the model contains a second 'early'
component that is absent when \code{FALSE} (the default).}

\item{intercept_form}{If \code{FALSE} (the default), the \code{a} parameter describes
the mu parameter in the model; if \code{TRUE}, the \code{a} parameter describes the
\code{k} parameter in the model (the intercept).}

\item{use_minmax}{If \code{FALSE} (the default), the optimiser targets the sum
of the goodness-of-fit values across datasets; if \code{TRUE}, it instead
targets the maximum of the goodness-of-fit values across datasets.}

\item{fit_criterion}{String indicating the criterion used to optimise the
fit by seeking its minimum.
\itemize{
\item \code{ks}: Kolmogorov-Smirnov statistic.
\item \code{likelihood}: Negative log-likelihood.
}}

\item{jitter_settings}{Settings for running the fitting multiple times with
randomly-generated offsets ('jitter') applied to the starting estimates.
\itemize{
\item \code{n}: How many jitter iterations to run (default of 7); the total number
of fits is \code{n + 1} (because the un-jittered start points are also fit).
\item \code{prop}: The maximum jitter offset, as a proportion of the start
value (default of 0.5).
\item \code{seed}: Seed for the random jitter generator (default is unseeded).
\item \code{processes}: Maximum number of CPU processes that can be used (default
is 2).
}}
}
\value{
A list of fitting arguments and outcomes.
\itemize{
\item \code{fitted_params} is a named list of fitted parameter values.
\item \code{named_fit_params} is a data frame with rows given by the dataset names
and columns given by the parameter names.
\item \code{loglike} is the overall log-likelihood of the fit.
\item \code{aic} is the "Akaike's 'An Information Criterion'" value for the model.
\item \code{optim_result} is the raw output from \code{stats::optim} for the best fit.
\item \code{jitter_optim_results} contains the raw output from each call to
\code{stats::optim} for the different start points.
}
}
\description{
Fit a LATER model to a single dataset or a pair of datasets.
}
\examples{
\donttest{
data <- data.frame(name = "test", promptness = rnorm(100, 3, 1))
data_other <- data.frame(name = "test_2", promptness = rnorm(100, 1, 1))
fit_shared_sigma <- fit_data(
  data = rbind(data, data_other), share_sigma = TRUE
)
}
}
