% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_fits.R
\name{compare_fits}
\alias{compare_fits}
\title{Compares the goodness-of-fit of a set of fit outcomes.}
\usage{
compare_fits(fits)
}
\arguments{
\item{fits}{A list where each item has a name that identifies the fit and a
value given by the output of \code{LATERmodel::fit_data}.}
}
\value{
A list of fit comparison results, ordered such that the fit with
the lowest AIC value is in the first row.
\itemize{
\item \code{aic} contains the fit AIC values.
\item \code{preferred_rel_fit_delta_aic} is the AIC value for the fit relative to
the AIC of the fit with the lowest AIC (preferred AIC - current AIC).
\item \code{preferred_rel_fit_evidence_ratio} is the evidence ratio for the fit with
the lowest AIC relative to the current fit.
\item \code{preferred} is a boolean that indicates whether the fit has the lowest
AIC value among the fits (is 'preferred').
}
}
\description{
Compares the goodness-of-fit of a set of fit outcomes.
}
\details{
The 'evidence ratio' is calculated as per Motulsky & Christopolous (2004),
p. 146.
}
\examples{
\donttest{
data <- rbind(
  data.frame(name = "test", time = 1000/rnorm(100, 3, 1)),
  data.frame(name = "test_2", time = 1000/rnorm(100, 1, 1))
) |> dplyr::filter(time > 0)
data <- prepare_data(data)
fit_a <- fit_data(data = data, share_a = TRUE)
fit_b <- fit_data(data = data, share_sigma = TRUE)
comparison <- compare_fits(fits = list(a = fit_a, b = fit_b))
}
}
