% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitLAD.R
\name{fitLAD}
\alias{fitLAD}
\title{Fit Leaf Angle Distribution (LAD) from two-parameters (mu, nu) Beta distribution}
\arguments{
\item{mu}{Numeric. The mu parameter of the Beta distribution.}

\item{nu}{Numeric. The nu parameter of the Beta distribution.}

\item{plot}{Logical. If set to TRUE, it plots the measured and theoretical LAD and G distributions. Default set to FALSE.}
}
\value{
A list of two elements:
\itemize{
\item dataset: a dataframe with three columns indicating the measured LAD (pdf), the G-function (G), for view or inclination angle (theta).
\item distribution: a vector containing the matched distribution type.
}
}
\description{
The function derives both the Leaf Angle Distribution (LAD) and the G-function from two-parameters (mu, nu) Beta distribution.
\itemize{
\item The LAD function is fitted through a Beta distribution as recommended by \href{doi:10.2134/agronj1984.00021962007600050021x}{Goel and Strebel (1984)}.
\item The G-function is derived from LAD using the formula provided by \href{doi:10.1007/978-94-009-8647-3}{Ross (1981)} and reported as Equations 2-3 by \href{doi:10.1007/s13595-018-0730-x}{Chianucci et al. (2018)}.
\item The fitted LAD is also compared with six theoretical LAD distributions provided by \href{https://library.wur.nl/WebQuery/wurpubs/413358}{de Wit (1965)}.
\item The distribution type is then classified using a leaf inclination index \href{https://cir.nii.ac.jp/crid/1571980074642440704}{Ross (1975)} and reported as Equation 8 by \href{doi:10.1007/s13595-018-0730-x}{Chianucci et al. (2018)}.
}
}
\examples{
fitLAD(0.9,0.9) # uniform LAD distribution
fitLAD(2.8,1.18)# planophile LAD distribution
fitLAD(1.1,1.7, plot=TRUE)# spherical LAD distribution

}
