% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genhighcorr.R
\name{GenSyntheticHighCorr}
\alias{GenSyntheticHighCorr}
\title{Generate Exponential Correlated Synthetic Data}
\usage{
GenSyntheticHighCorr(
  n,
  p,
  k,
  seed,
  rho = 0,
  b0 = 0,
  snr = 1,
  mu = 0,
  base_cor = 0.9
)
}
\arguments{
\item{n}{Number of samples}

\item{p}{Number of features}

\item{k}{Number of non-zeros in true vector of coefficients}

\item{seed}{The seed used for randomly generating the data}

\item{rho}{The threshold for setting values to 0.  if |X(i, j)| > rho => X(i, j) <- 0}

\item{b0}{intercept value to scale y by.}

\item{snr}{desired Signal-to-Noise ratio. This sets the magnitude of the error term 'e'. 
SNR is defined as  SNR = Var(XB)/Var(e)}

\item{mu}{The mean for drawing from the Multivariate Normal Distribution. A scalar of vector of length p.}

\item{base_cor}{The base correlation, A in [i, j] = A^|i-j|.}
}
\value{
A list containing:
 the data matrix X,
 the response vector y,
 the coefficients B,
 the error vector e,
 the intercept term b0.
}
\description{
Generates a synthetic dataset as follows: 1) Generate a correlation matrix, SIG,  where item [i, j] = A^|i-j|.
2) Draw from a Multivariate Normal Distribution using (mu and SIG) to generate X. 3) Generate a vector B with every ~p/k entry set to 1 and the rest are zeros.
4) Sample every element in the noise vector e from N(0,1). 4) Set y = XB + b0 + e.
}
