% Generated by roxygen2: do not edit by hand
\name{compute_stochastic_profile}
\alias{compute_stochastic_profile}
\title{Compute Stochastic Profile}
\usage{
compute_stochastic_profile(sample_values, pc_values, nc_values)
}
\arguments{
\item{sample_values}{Numeric vector of sample measurements}

\item{pc_values}{Numeric vector of positive control measurements}

\item{nc_values}{Numeric vector of negative control measurements}
}
\value{
List containing comprehensive stochastic metrics:
\describe{
  \item{mean, var, cv, fano}{Basic sample statistics}
  \item{cv_ratio_pc, cv_ratio_nc}{CV ratios vs controls}
  \item{fano_ratio_pc}{Fano factor ratio vs PC}
  \item{stochastic_index}{Normalized position between NC and PC variance}
  \item{ssmd_vs_nc, ssmd_vs_pc}{SSMD vs controls}
  \item{snr}{Signal-to-noise ratio vs NC}
  \item{js_vs_pc, js_vs_nc, js_ratio}{Jensen-Shannon metrics}
  \item{energy_vs_pc, energy_vs_nc, energy_ratio}{Energy distance metrics}
  \item{wasserstein_vs_pc, wasserstein_vs_nc, wasserstein_ratio}{Wasserstein metrics}
  \item{log_dist_pc, log_dist_nc}{Log-space Euclidean distances}
}
}
\description{
Computes comprehensive stochastic metrics for a sample compared to controls.
}
\examples{
set.seed(42)
pc <- rnorm(20, 100, 10)
nc <- rnorm(20, 20, 5)
sample <- rnorm(20, 80, 15)
profile <- compute_stochastic_profile(sample, pc, nc)
}
