% Generated by roxygen2: do not edit by hand
\name{kwela_plate_normalize}
\alias{kwela_plate_normalize}
\alias{kwela_bootstrap_summary}
\title{Plate Normalization and Bootstrap}
\usage{
kwela_plate_normalize(
  data,
  plate_col = "Plate",
  pc_pattern = "\\\\bPositive\\\\s*Control\\\\b|^POS\\\\b|\\\\bPC\\\\b",
  nc_pattern = "\\\\bNegative\\\\s*Control\\\\b|^NEG\\\\b|\\\\bNC\\\\b|\\\\bTDB\\\\b|\\\\bBlank\\\\b",
  method = c("zscore", "median_ratio")
)

kwela_bootstrap_summary(result, B = 1000, conf = 0.95)
}
\arguments{
\item{data}{Data frame with Treatment, TTT, MP columns}

\item{plate_col}{Name of plate identifier column}
 
\item{pc_pattern}{Regex for positive controls}

\item{nc_pattern}{Regex for negative controls}

\item{method}{Normalization method: "zscore" or "median_ratio"}

\item{result}{Output from \code{kwela_analyze}}

\item{B}{Number of bootstrap replicates (default 1000)}

\item{conf}{Confidence level (default 0.95)}
}
\value{
\code{kwela_plate_normalize} returns a data frame with added columns:
\describe{
  \item{plate_id}{Plate identifier}
  \item{TTT_norm}{Normalized TTT values}
  \item{MP_norm}{Normalized MP values}
}

\code{kwela_bootstrap_summary} returns a data frame with:
\describe{
  \item{Treatment}{Treatment name}
  \item{n_wells}{Number of wells}
  \item{mean_score}{Mean well score}
  \item{score_lo}{Lower CI bound for mean score}
  \item{score_hi}{Upper CI bound for mean score}
  \item{positive_rate}{Observed positive rate}
  \item{pr_lo}{Lower CI bound for positive rate}
  \item{pr_hi}{Upper CI bound for positive rate}
}
}
\description{
\code{kwela_plate_normalize} normalizes TTT and MP values within each
plate using negative control baselines.

\code{kwela_bootstrap_summary} computes bootstrap confidence intervals
for treatment scores. Set seed externally for reproducibility.
}
\examples{
\donttest{
set.seed(42)
df <- data.frame(
  Treatment = c(rep("Positive Control", 4), rep("Negative Control", 4),
                rep("Sample_A", 4)),
  TTT = c(rnorm(4, 8, 1), rnorm(4, 72, 5), rnorm(4, 12, 3)),
  MP = c(rnorm(4, 100, 10), rnorm(4, 20, 5), rnorm(4, 85, 15)),
  Plate = rep("Plate1", 12)
)
normalized <- kwela_plate_normalize(df)

# Bootstrap example
result <- kwela_analyze(df, verbose = FALSE)
set.seed(123)
boot <- kwela_bootstrap_summary(result, B = 500)
}
}
