% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.JointFPM.R
\name{predict.JointFPM}
\alias{predict.JointFPM}
\title{Post-estimation function for JointFPMs}
\usage{
\method{predict}{JointFPM}(
  object,
  type = "mean_no",
  newdata,
  t,
  exposed = NULL,
  ci_fit = TRUE,
  method = "romberg",
  ngq = 30,
  ...
)
}
\arguments{
\item{object}{A joint flexible parametric model of class \code{JointFPM}.}

\item{type}{A character vector defining the estimate of interest. Currently available
options are:
\describe{
\item{\code{mean_no}: }{Estimates the mean number of events at time(s) \code{t}.}
\item{\code{diff}: }{Estimates the difference in mean number of events
between exposed and unexposed at time(s) \code{t}.}
\item{\code{marg_mean_no}: }{Estimates the marginal mean number of events.}
\item{\code{marg_diff}: }{Estimates the marginal difference in the mean
number of events.}
}}

\item{newdata}{A \code{data.frame} with one row including the variable values used for t
he prediction. One value for each variable used in either the recurrent or
competing event model is required when predicting \code{mean_no} or \code{diff}.
For \code{marg_mean_no} or \code{marg_diff}, this includes the variable
that you would like your marginal estimate to be conditioned on.}

\item{t}{A vector defining the time points used for the prediction.}

\item{exposed}{A function that takes \code{newdata} as an argument and creates a new dataset
for the exposed group. This argument is required if \code{type = 'diff'}.
Please see details for more information.}

\item{ci_fit}{Logical indicator for whether confidence intervals should be estimated
for the fitted estimates using the delta method.}

\item{method}{The method used for the underlying numerical integration procedure.
Defaults to \code{"romberg"}, which uses the \code{\link[rmutil:int]{rmutil::int()}} function,
but it is possible to use Gaussian quadrature by setting
\code{method = "gq"} instead.}

\item{ngq}{Number of quadrature nodes used when \code{method = "gq"}. Defaults to 30,
which lead to accurate results (compared to \code{method = "romberg"}) in our
experience.}

\item{...}{Added for compatibility with other predict functions.}
}
\value{
A \code{data.frame} with the following columns:
\describe{
\item{\code{t}: }{The time for the prediction,}
\item{\code{fit}: }{The point estimate of the prediction,}
\item{\code{lci}: }{The lower confidence interval limit,}
\item{\code{uci}: }{The upper confidence interval limit.}
}
}
\description{
Predicts different estimates from a joint flexible parametric model.
Currently only the estimation of the mean number of events at different
time points is supported.
}
\details{
The function required for the \code{exposed} argument must take the \code{newdata}
dataset as argument and transform it to a new dataset that defines the
exposed group. Assume we assume that we have a model with one variable
\code{trt} which is a 0/1 coded treatment indicator. If we would like to obtain
the difference in mean number of events comparing the untreated to treated
group we could use the following function assuming that
\code{newdata = data.frame(trt = 0)}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{function(x)\{transform(x, trt = 1)\}
}\if{html}{\out{</div>}}
}
\examples{
bldr_model <- JointFPM(Surv(time  = start,
                            time2 = stop,
                            event = event,
                            type  = 'counting') ~ 1,
                       re_model = ~ pyridoxine + thiotepa,
                       ce_model = ~ pyridoxine + thiotepa,
                       re_indicator = "re",
                       ce_indicator = "ce",
                       df_ce = 3,
                       df_re = 3,
                       cluster  = "id",
                       data     = bladder1_stacked)

predict(bldr_model,
        newdata = data.frame(pyridoxine = 1,
                             thiotepa   = 0),
        t       =  c(10, 20),
        ci_fit  = FALSE)

}
