% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracks.R
\name{getTracksNamesearch}
\alias{getTracksNamesearch}
\title{Search Jamendo database for a track}
\usage{
getTracksNamesearch(
  namesearch,
  limit = 10,
  client_id = Sys.getenv("JAMENDO_CLIENT_ID")
)
}
\arguments{
\item{namesearch}{Search a track by name}

\item{limit}{Integer to set the number of displayed search results. Maximum value is 200.}

\item{client_id}{Defaults to System Environment variable "JAMENDO_CLIENT_ID"}
}
\value{
Returns a data frame which contains information about a track.
See \url{https://developer.jamendo.com/v3.0/tracks} for more information.
}
\description{
Search Jamendo database for a track by name with namesearch.
}
\examples{
\donttest{
##Examples
 tracks <- getTracksNamesearch("ambient",limit=3)
}
}
