% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_psr.R
\name{sim_psr}
\alias{sim_psr}
\title{Single-Index signal regression using P-splines}
\usage{
sim_psr(
  y,
  X,
  x_index = c(1:ncol(X)),
  nsegs = rep(10, 2),
  bdegs = rep(3, 3),
  lambdas = rep(1, 2),
  pords = rep(2, 2),
  max_iter = 100
)
}
\arguments{
\item{y}{a response vector of length \code{m}, usually continuous.}

\item{X}{The signal regressors with dimension \code{m} by \code{p}.}

\item{x_index}{an index of length \code{p} for columns of signal matrix;
default is simple sequence, \code{c(1: ncol(X))}.}

\item{nsegs}{a vector of length 2 containing
the number of evenly spaced segments between min and max, for each
the coefficient vector and the (unknown) link function,
resp. (default \code{c(10, 10)}).}

\item{bdegs}{a vector of length 2 containing
the degree of B-splines, for the coefficient vector and
the (unknown) link function, resp. (default cubic or \code{c(3, 3)}).}

\item{lambdas}{a vector of length 2 containing
the positive tuning parameters, for each
the coefficient vector and the (unknown) link function, resp. (default \code{c(1, 1)}).}

\item{pords}{a vector of length 2 containing
the difference penalty order, for each
the coefficient vector and the (unknown) link function, resp. (default\code{c(2, 2)} ).}

\item{max_iter}{a scalar for the maximum number of iterations (default 100).}
}
\value{
\item{y}{the response vector of length \code{m}.}
\item{alpha}{the P-spline coefficient vector of length \code{(nsegs[1]+bdeg[1])}.}
\item{iter}{the number of iterations used for the single-index fit.}
\item{yint}{the estimated y-intercept for the single-index model.}
\item{B}{the B-spline matrix built along the signal index, using \code{nsegs[1]}, used for the coefficient vector.}
\item{Q}{the effective regressors from the \code{psVCSignal} portion of the single-index
fit with dimension \code{m} by \code{length(alpha)}.}
\item{nsegs}{a vector of length 2 containing
the number of evenly spaced segments between min and max, for each
the coefficient vector and the link function, resp.}
\item{bdegs}{a vector of length 2 containing
the degree of B-splines, for each
the coefficient vector and the link function, resp.}
\item{lambdas}{a vector of length 2 containing
the positive tuning parameters, for each
the coefficient vector and the link function, resp.}
\item{pords}{a vector of length 2 containing
the difference penalty order, for each
the coefficient vector and the link function, resp.}
\item{eta}{the estimated linear predictor for the single-index fit.}
\item{cv}{the leave-one-out cross-validation statistic or the standard error of prediction for the single-index fit.}
\item{delta_alpha}{change measure in signal-coefficent parameters at
convervence.}
\item{x_index}{the index of length \code{p} for columns of signal matrix.}
\item{f_fit}{the \code{psNormal} object, fitting link function f(\code{eta}).}
\item{f_eta}{the predicted values of the link function estimated with \code{f_fit} or estimated f(\code{eta}), at \code{x = eta}.}
}
\description{
\code{sim_psr} is a single-index
signal regression model that estimates both the signal coefficients
vector and the unknown link function using P-splines.
}
\examples{
library(JOPS)
# Get the data
library(fds)
data(nirc)
iindex <- nirc$x
X <- nirc$y
sel <- 50:650 # 1200 <= x & x<= 2400
X <- X[sel, ]
iindex <- iindex[sel]
dX <- diff(X)
diindex <- iindex[-1]
y <- as.vector(labc[1, 1:40])
oout <- 23
dX <- t(dX[, -oout])
y <- y[-oout]

pords <- c(2, 2)
nsegs <- c(27, 7)
bdegs = c(3, 3)
lambdas <- c(1e-6, .1)
max_iter <- 100

# Single-index model
fit <- sim_psr(y, dX, diindex, nsegs, bdegs, lambdas, pords,
             max_iter)

plot(fit, xlab = "Wavelength (nm)", ylab = " ")

}
\references{
Eilers, P.H.C., B. Li, B.D. Marx (2009).
Multivariate calibration with single-index signal regression,
\emph{Chemometrics and Intellegent Laboratory Systems}, 96(2), 196-202.

Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
\author{
Paul Eilers, Brian Marx, and Bin Li
}
