% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectifiedI.R
\name{loadDistanceMatrix}
\alias{loadDistanceMatrix}
\title{Loads a distance matrix. Instead of computing the distance from latitute and longitude
\code{LoadDistanceMatrix} Loads the distance matrix, avoiding computing it from latitude and longitude.}
\usage{
loadDistanceMatrix(fileName, colnames = TRUE, rownames = TRUE)
}
\arguments{
\item{fileName}{file's name and path to the file}

\item{colnames}{If the first row of the file is the names for the columns. The default value is TRUE}

\item{rownames}{If the first column is the the row names. The default value is TRUE}
}
\value{
The distance matrix
}
\description{
Loads a distance matrix. Instead of computing the distance from latitute and longitude
\code{LoadDistanceMatrix} Loads the distance matrix, avoiding computing it from latitude and longitude.
}
\examples{
fileInput <- system.file("testdata", "chenDistance.csv", package="Irescale")
distM<-loadDistanceMatrix(fileInput)
}
