% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_infotables.R
\name{plot_infotables}
\alias{plot_infotables}
\title{Create bar charts for WOE or NWOE vectors}
\usage{
plot_infotables(information_object = NULL, variables = NULL,
  same_scales = FALSE, show_values = FALSE)
}
\arguments{
\item{information_object}{object generated by the information package.}

\item{variables}{vector of one more variables. For multi-variable plots, bar charts will be displayed in a grid.}

\item{same_scales}{if set to TRUE, all plots will have the same limits on the y-axes (default is FALSE).}

\item{show_values}{if set to TRUE, values will be displayed on the bar chart (default is FALSE).}
}
\description{
\code{plot_infotable} creates WOE or NWOE bar charts for one or more variables. 
For multi-variable plots, bar charts will be displayed in a grid for comparison.
}
\examples{
 
##------------------------------------------------------------
## WOE plots
##------------------------------------------------------------
library(Information)
data(train, package="Information")
train <- subset(train, TREATMENT==1)
IV <- Information::create_infotables(data=train, y="PURCHASE", parallel=FALSE)

# Plotting a single variable
Information::plot_infotables(IV, "N_OPEN_REV_ACTS")

# Plotting multiple variables in a grid for comparison
Information::plot_infotables(IV, IV$Summary$Variable[1:4], same_scale=TRUE)

# If the goal is to plot multiple variables individually, as opposed to a comparison-grid, we can
# loop through the variable names and create individual plots
\dontrun{
names <- names(IV$Tables)
plots <- list()
for (i in 1:length(names)){
  plots[[i]] <- plot_infotables(IV, names[i])
}
# Showing the top 18 variables
plots[1:18]
}

# We can speed up the creation of the information tables by invoking the parallel option (default)
# If we leave ncore as the default, create_infotables() will set ncore to available clusters - 1
\dontrun{
train <- subset(train, TREATMENT==1)
IV <- Information::create_infotables(data=train, y="PURCHASE")
}
closeAllConnections()
}

