% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImML.r
\name{ImML}
\alias{ImML}
\title{Tree volume models based on height and diameter}
\usage{
ImML(data, plotit = TRUE, setseed = NULL, verbose = FALSE, ...)
}
\arguments{
\item{data}{The data frame to use.
Must contain the numeric variables
\code{Volume}, \code{Height}, and \code{Diameter}.}

\item{plotit}{If \code{TRUE}, produces a plot of predicted values vs.
observed values.}

\item{setseed}{If not \code{NULL}, is passed to \code{set.seed} 
for the analysis.}

\item{verbose}{If \code{TRUE}, prints the output of each fitted model object.}

\item{...}{Additional arguments, currently not used.}
}
\value{
A data frame consisting of mean absolute error, 
        root mean square error,
        root relative squared error, and prediction error rate
        for train and test partitions
        using decision tree, random forest, support vector machine,
         and linear model.
}
\description{
Decision tree, random forest, support vector machine,
             and linear models for fitting tree volume to
             height and diameter.
}
\details{
Calculates mean absolute error, root mean square error,
         root relative squared error, and prediction error rate
         for train and test partitions of a data frame
         using decision tree, random forest, support vector machine,
         and linear models for fitting tree volume to
         height and diameter.
}
\note{
The data frame must contain the numeric variables
        \code{Volume}, \code{Height}, and \code{Diameter}.
        \code{Volume} is used as the dependent variable.
        
        The gray line in the plot is a 1:1 line.
}
\examples{
data(EastCirclePine)
ImML(EastCirclePine, plotit=FALSE, setseed=123)

}
\references{
Jeelani, M.I., Tabassum, A., Rather, K and Gul,M.2023. 
            Neural Network Modeling of Height Diameter Relationships 
            for Himalayan Pine through Back Propagation Approach. 
            Journal of The Indian Society of Agricultural Statistics. 
            76(3): 169–178.
}
\author{
M. Iqbal Jeelani, \email{jeelani.miqbal@gmail.com},
        Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{Decision tree}
\concept{Random forest}
\concept{Support vector machine}
\concept{Tree volume}
