% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IVYplot.R
\name{IVYplot}
\alias{IVYplot}
\title{IVY Plot}
\usage{
IVYplot(
  data0,
  showFreq = TRUE,
  freqSize = 1,
  multiple = NULL,
  delta = 1,
  limA = NULL,
  limB = NULL
)
}
\arguments{
\item{data0}{The data vector the user will input}

\item{showFreq}{Option for the user to show the frequencies at each value or not. TRUE = show/FALSE = do not show.
Default is TRUE}

\item{freqSize}{The font size of the frequencies if the user wants to show the frequencies. Default is 1.0}

\item{multiple}{The maximum number of observations each leaflet represents. Default is calculated to ensure at most 20 leaves
at each value}

\item{delta}{The gap between successive values. Default is 1}

\item{limA}{The lower limit on the horizontal axis. Default is minimum of the values}

\item{limB}{The upper limit on the horizontal axis. Default is maximum of the values}
}
\value{
Gives you an IVY plot
}
\description{
The function will draw an IVY Plot (similar to Dot Plot) with/without frequencies
}
\examples{
  IVYplot(data0 = c(rpois(500, 10), 30, 30, 30), freqSize = 1.5, multiple = 3)
}
