% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.r
\name{centrality_radar}
\alias{centrality_radar}
\title{Radar plot for selected centrality measures}
\usage{
centrality_radar(
  cent,
  measures = c("outdegree", "indegree", "outEI", "inEI", "bridgestrength",
    "bridgeoutdegree", "bridgeindegree", "bridgebetweenness", "bridgecloseness",
    "bridgeEI_1", "bridgeEI_2"),
  title = NULL,
  axis_range = NULL,
  add_legend = TRUE,
  legend_pos = "bottomright",
  ...
)
}
\arguments{
\item{cent}{A list returned by \code{\link{centrality}}.}

\item{measures}{Character vector of measures to plot. Allowed values:
\itemize{
\item \code{outdegree}, \code{indegree}, \code{outEI}, \code{inEI}
\item \code{bridgestrength}, \code{bridgeoutdegree}, \code{bridgeindegree},
\code{bridgebetweenness}, \code{bridgecloseness}, \code{bridgeEI_1}, \code{bridgeEI_2}
}}

\item{title}{Optional character title. If provided and \code{...} does not already set \code{title},
it is passed to \code{fmsb::radarchart(title = ...)}.}

\item{axis_range}{Numeric length-2 vector \code{c(min, max)} for the radial axis. If \code{NULL},
computed from the selected measures.}

\item{add_legend}{Logical. If \code{TRUE}, adds a base-R legend with one entry per selected measure.}

\item{legend_pos}{Character position, e.g. \code{"bottomright"}, \code{"topright"}, etc.}

\item{...}{Additional arguments forwarded to \code{\link[fmsb]{radarchart}}.}
}
\value{
Invisibly returns the data frame used for plotting (in \pkg{fmsb} format):
the first row is \code{max}, the second row is \code{min}, and subsequent rows correspond
to the requested centrality measures.
}
\description{
Creates a radar chart (via \code{\link[fmsb]{radarchart}}) from the output of
\code{\link{centrality}}.
}
\examples{
W <- matrix(c(
  0,  0.4, -0.2, 0,
  0.4, 0,   0.1, 0.3,
  -0.2, 0.1, 0,   0.2,
  0,   0.3, 0.2, 0
), nrow = 4, byrow = TRUE)
colnames(W) <- rownames(W) <- c("A", "B", "C", "D")

cent <- centrality(W)

# Plot degree + EI
# pdf('radar_plot.pdf')
centrality_radar(cent, measures = c("outdegree", "outEI"),
                 axis_range = c(0, 1), plwd = 2,
                 seg = 5, caxislabel = seq(0,1,0.2))
# dev.off()

# If bridge metrics were computed:

comm <- c(A="X", B="X", C="Y", D="Y")
cent_b <- centrality(W, communities = comm)
centrality_radar(cent_b, measures = c("bridgestrength", "bridgebetweenness"))

}
\seealso{
\code{\link{centrality}}, \code{\link[fmsb]{radarchart}}
}
