% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial.R
\name{iscambinompower}
\alias{iscambinompower}
\title{Rejection Region for Binomial}
\usage{
iscambinompower(LOS, n, prob1, alternative, prob2 = NULL, verbose = TRUE)
}
\arguments{
\item{LOS}{A numeric value representing the level of significance}

\item{n}{A numeric value representing the sample size}

\item{prob1}{A numeric value representing the first probability}

\item{alternative}{"less", "greater", or "two.sided"}

\item{prob2}{A numeric value representing the second probability}

\item{verbose}{Logical, defaults to \code{TRUE}. Set to \code{FALSE} to suppress messages}
}
\value{
A plot of the binomial distribution with the rejection region highlighted.
}
\description{
\code{binompower} determines the rejection region corresponding to the level of
significance and the first probability and shows the binomial distribution
shading its corresponding region.
}
\examples{
iscambinompower(LOS = 0.05, n = 20, prob1 = 0.5, alternative = "less")

iscambinompower(LOS = 0.05, n = 20, prob1 = 0.5, alternative = "greater", prob2 = 0.75)

iscambinompower(LOS = 0.10, n = 30, prob1 = 0.4, alternative = "two.sided")

iscambinompower(LOS = 0.10, n = 30, prob1 = 0.4, alternative = "two.sided", prob2 = 0.2)
}
